package com.xebialabs.xlplatform.endpoints.servlet

import javax.servlet.AsyncContext
import javax.servlet.http.HttpServletResponse

import akka.http.scaladsl.model.headers.RawHeader
import akka.http.scaladsl.model._
import org.apache.commons.lang.StringEscapeUtils.unescapeXml

class FlexAkkaStreamServlet() extends AkkaStreamServlet {
  override protected def writeServletHttpResponse(ac: AsyncContext)(req: HttpRequest, resp: HttpResponse, out: HttpServletResponse): Unit = {
    val modified: HttpResponse = resp.entity match {
      case HttpEntity.Strict(contentType, data) if isFlexInitiatedApiMetadataRequest(req) =>
        val originalStatus: Int = resp.status.intValue
        val wrappedData: String = unescapeXml(
          <response>
            <entity>
              {data.decodeString("UTF-8")}
            </entity>
            <status>
              {originalStatus}
            </status>
          </response>.toString
        )
        resp
          .addHeader(RawHeader(FlexAkkaStreamServlet.X_ORIGINAL_STATUS_HEADER, originalStatus.toString))
          .copy(status = StatusCodes.OK, entity = wrappedData)
      case _ => resp
    }
    super.writeServletHttpResponse(ac)(req, modified, out)
  }

  protected def isFlexInitiatedApiMetadataRequest(req: HttpRequest): Boolean =
    req.headers.exists(header => header.name.toLowerCase == "x-flex-rest" && header.value == "true")
}

object FlexAkkaStreamServlet {
  protected val X_FLEX_REST = "X-Flex-Rest"
  val X_ORIGINAL_STATUS_HEADER = "X-Original-Status"
  val X_METHOD_OVERRIDE_HEADER = "X-HTTP-Method-Override"
}
