package com.xebialabs.xlplatform.settings

import akka.actor.{ActorContext, ExtendedActorSystem, Extension, ExtensionId, ExtensionIdProvider}
import akka.util.Timeout
import com.typesafe.config.Config
import com.typesafe.config.ConfigFactory.parseResources
import com.xebialabs.xlplatform.config.ConfigurationHolder
import com.xebialabs.xlplatform.settings.XlPlatformSettings

import java.util.concurrent.TimeUnit

class ExtensionSettings(config: Config) extends XlPlatformSettings(config) {
}

object ExtensionSettings extends ExtensionId[ExtensionSettings] with ExtensionIdProvider {
  override def lookup() = ExtensionSettings

  override def createExtension(system: ExtendedActorSystem) = apply(system.settings.config)

  def apply(implicit context: ActorContext): XlPlatformSettings = apply(context.system)

  def apply(defaultConfig: Config): ExtensionSettings = {
    val config: Config = parseResources("xl-platform.conf")
    val productConfiguration = ConfigurationHolder.get()
    new ExtensionSettings(
      if (productConfiguration != null) {
        config.withFallback(productConfiguration.withFallback(defaultConfig))
      } else {
        config.withFallback(defaultConfig)
      }
    )
  }
}
