package com.xebialabs.xlplatform.endpoints.security

import com.xebialabs.xlplatform.endpoints.security.CustomHttpHeaders.`X-User-Principal`
import org.apache.pekko.http.scaladsl.model.headers.HttpChallenge
import org.apache.pekko.http.scaladsl.server.AuthenticationFailedRejection.CredentialsRejected
import org.apache.pekko.http.scaladsl.server.{AuthenticationFailedRejection, RequestContext}

import scala.concurrent.ExecutionContext
import scala.reflect._

object RequestPrincipal {
  def apply[T](principalVerifier: PrincipalVerifier[T])(implicit ec: ExecutionContext): RequestPrincipalAuthenticator[T] =
    new RequestPrincipalAuthenticator[T](principalVerifier)
}

class RequestPrincipalAuthenticator[T](val principalVerifier: PrincipalVerifier[T])
                                      (implicit val executionContext: ExecutionContext) {
  def apply(ctx: RequestContext): Either[AuthenticationFailedRejection, T] = {
    principalVerifier(ctx.request.header(classTag[`X-User-Principal`]).map(_.principal)) match {
      case None => Left(AuthenticationFailedRejection(CredentialsRejected, HttpChallenge("Basic", None)))
      case Some(t) => Right(t)
    }
  }
}
