package com.xebialabs.xlplatform


import org.apache.pekko.http.scaladsl.server.Directives._
import org.apache.pekko.http.scaladsl.server.{PathMatcher0, Route}

package object endpoints {
  type AuthenticatedRoute = AuthenticatedData => Route

  def segments(path: String): PathMatcher0 = {
    Option(path) match {
      case None | Some("") => Neutral
      case Some(string) if string.startsWith("/") => separateOnSlashes(string)
      case Some(string) => Slash ~ separateOnSlashes(string)
    }
  }
}
