package com.xebialabs.xlplatform.endpoints.security

import org.apache.pekko.http.scaladsl.model.headers.{ModeledCustomHeader, ModeledCustomHeaderCompanion}

import java.security.Principal
import scala.util.{Failure, Try}

object CustomHttpHeaders {

  final class `X-User-Principal`(val principal: Principal) extends ModeledCustomHeader[`X-User-Principal`] {
    override def renderInRequests = true

    override def renderInResponses = true

    override val companion: `X-User-Principal`.type = `X-User-Principal`
    override val value: String = principal.getName
  }

  object `X-User-Principal` extends ModeledCustomHeaderCompanion[`X-User-Principal`] {
    override val name: String = "X-User-Principal"

    override def parse(value: String): Try[`X-User-Principal`] = Failure(new RuntimeException("Cannot parse X-User-Principal header"))

    def apply(principal: Principal): `X-User-Principal` = new `X-User-Principal`(principal)
  }
}
