package com.xebialabs.xlplatform.spring;

import com.xebialabs.platform.script.jython.Bindings;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import static scala.jdk.javaapi.CollectionConverters.asJava;

public class JythonBindingsHolder {

    private static Map<String, Object> bindings;

    public static Map<String, Object> getBindings() {
        if (bindings != null) {
            return bindings;
        }
        // Fall back to XL Deploy bindings until the initialization logic is moved to xl-deploy project
        return asJava(Bindings.xlDeployApiServices());
    }

    @SuppressWarnings("UnusedDeclaration")
    public static void setBindings(Map<String, Object> bindings) {
        JythonBindingsHolder.bindings = Collections.unmodifiableMap(new HashMap<>(bindings));
    }

}
