package com.xebialabs.license;

import java.util.Arrays;
import java.util.List;

import static com.xebialabs.license.LicenseProperty.CONTACT;
import static com.xebialabs.license.LicenseProperty.EDITION;
import static com.xebialabs.license.LicenseProperty.EXPIRES_AFTER;
import static com.xebialabs.license.LicenseProperty.LICENSED_PLUGINS;
import static com.xebialabs.license.LicenseProperty.LICENSED_TO;
import static com.xebialabs.license.LicenseProperty.LICENSE_VERSION;
import static com.xebialabs.license.LicenseProperty.MAX_NUMBER_OF_CIS;
import static com.xebialabs.license.LicenseProperty.MAX_NUMBER_OF_USERS;
import static com.xebialabs.license.LicenseProperty.PRODUCT;
import static com.xebialabs.license.LicenseProperty.REPOSITORY_ID;
import static com.xebialabs.license.LicenseProperty.SUPPORT_POLICY;
import static java.lang.String.format;

public class LicenseVersion3 extends License {
    public static final int VERSION = 3;

    public enum Edition {
        Community,
        Enterprise,
        Trial;

        public static boolean contains(String editionName) {
            for (Edition edition : Edition.values()) {
                if (edition.name().equals(editionName)) {
                    return true;
                }
            }
            return false;
        }
    }

    public LicenseVersion3(LicensePropertyMap values) throws LicenseViolationException {
        super(values);
    }

    @Override
    public int getLicenseVersion() {
        return VERSION;
    }

    @Override
    public List<LicenseProperty> getLicenseProperties() {
        return Arrays.asList(LICENSE_VERSION, PRODUCT, LICENSED_TO, CONTACT, REPOSITORY_ID, EXPIRES_AFTER,
                MAX_NUMBER_OF_USERS, MAX_NUMBER_OF_CIS, LICENSED_PLUGINS, SUPPORT_POLICY, EDITION);
    }

    @Override
    public List<LicenseProperty> getRequiredProperties() {
        return Arrays.asList(LICENSE_VERSION, PRODUCT, LICENSED_TO, CONTACT, EDITION);
    }

    @Override
    public void validateLicenseFormat() throws LicenseViolationException {
        super.validateLicenseFormat();
        validateEdition();
    }

    private void validateEdition() throws LicenseViolationException {
        if (!hasLicenseProperty(LicenseProperty.EDITION)) {
            throw new LicenseEditionException(format("For this version of %s, a license edition Enterprise or Trial is required, not the license contains none.", getStringValue(LicenseProperty.PRODUCT)));
        }

        String licenseEdition = getStringValue(LicenseProperty.EDITION);
        if (!LicenseVersion3.Edition.contains(licenseEdition)) {
            throw new LicenseEditionException(format("For this version of %s, a license edition Enterprise or Trial is required. Edition type %s is invalid", getStringValue(LicenseProperty.PRODUCT), licenseEdition));
        }

    }
}
