package com.xebialabs.license;

public class LicenseRepositoryIdException extends LicenseViolationException {

    private final String newId;

    public LicenseRepositoryIdException(String newId) {
        super(String.format("New repository id '%s' is different from current repository id", newId));
        this.newId = newId;
    }

    public String getNewId() {
        return newId;
    }
}

