package com.xebialabs.license;


import java.io.IOException;
import java.text.ParseException;

import static com.xebialabs.deployit.checks.Checks.checkNotNull;

/**
 * Exception in case parsing of a license message failes, for example because of malformed Base64
 */
public class LicenseParseException extends RuntimeException {

    private final String originalMessage;

    public LicenseParseException(String message) {
        super(message);
        this.originalMessage = checkNotNull(message, "message");
    }

    public LicenseParseException(String message, Throwable cause) {
        super(message, cause);
        this.originalMessage = checkNotNull(message, "message");
    }

    public LicenseParseException(String licenseMessage, final String message) {
        super(message);
        this.originalMessage = checkNotNull(licenseMessage, "licenseMessage");
    }

    public LicenseParseException(String licenseMessage, final String message, Throwable cause) {
        super(message, cause);
        this.originalMessage = checkNotNull(licenseMessage, licenseMessage);
    }

    public String getOriginalMessage() {
        return originalMessage;
    }
}
