package com.xebialabs.license.service;

import com.xebialabs.deployit.plugin.api.reflect.Type;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

/*
 * This class counts the number of CI creation and deletion during a transaction.
 * In case of failure during the transaction it will rollback the counts in
 * LicenseCiCounter field typeCounter
 */
public class LicenseTransaction {

    private static final Function<Type, AtomicInteger> COMPUTE_FUNCTION = t -> new AtomicInteger(0);

    /*
     * This cache has no invalidation rules and functions as a map with a default value.
     */
    private Map<Type, AtomicInteger> ciCountByType = new HashMap<>();

    public void registerCreate(Type t, int n) {
        ciCountByType.computeIfAbsent(t, COMPUTE_FUNCTION).addAndGet(n);
    }

    public void registerDelete(Type t, int n) {
        ciCountByType.computeIfAbsent(t, COMPUTE_FUNCTION).addAndGet(-n);
    }

    public Set<Type> getCiCountTypes() {
        return ciCountByType.keySet();
    }

    public int getCiCount(Type type) {
        return ciCountByType.computeIfAbsent(type, COMPUTE_FUNCTION).get();
    }
}
