package com.xebialabs.plugin.manager.materializer

import org.apache.maven.artifact.versioning.ComparableVersion

object VersionComparisonUtils {

  def isLowerVersion(thisVersion: String, thatVersion: String): Boolean = {
    new ComparableVersion(thisVersion).compareTo(new ComparableVersion(thatVersion)) < 0
  }

  def isSameVersion(thisVersion: String, thatVersion: String): Boolean = {
    new ComparableVersion(thisVersion).compareTo(new ComparableVersion(thatVersion)) == 0
  }
}
