package com.xebialabs.plugin.manager

import com.xebialabs.plugin.manager.metadata.{ArtifactId, PluginsMetadata}

import scala.concurrent.{ExecutionContext, Future}


trait PluginManager {
  implicit val ec: ExecutionContext

  def name: String

  def listInstalled(): Seq[PluginId]

  def install(plugin: Plugin): Unit

  def uninstall(id: PluginId): Boolean

  def search(query: Option[String]): Future[Map[ArtifactId, PluginsMetadata]] = Future.successful {
    val results = query match {
      case Some(pluginName) if pluginName.nonEmpty => listInstalled().filter(_.id.contains(pluginName))
      case None => listInstalled()
    }
    results.map(id => id.toArtifactId -> PluginsMetadata.empty(id.pluginVersion)).toMap
  }

}