package com.xebialabs.plugin.manager.metadata

import akka.http.scaladsl.marshallers.sprayjson.SprayJsonSupport
import spray.json._


case class PluginsMetadata(metadata: Option[ExtendedMetadata], versions: Set[Option[Version.Constant]], hasLogo: Boolean)

object PluginsMetadata {
  def empty(version: Option[Version.Constant]) = PluginsMetadata(None, Set(version), hasLogo = false)
  def empty(versions: Iterable[Option[Version.Constant]]) = PluginsMetadata(None, versions.toSet, hasLogo = false)

  trait Protocol extends SprayJsonSupport with DefaultJsonProtocol
    with ExtendedMetadata.Protocol
    with Version.Constant.Protocol {

    implicit val pluginsMetadataWriter: RootJsonWriter[PluginsMetadata] = {
      case PluginsMetadata(metadata, versions, hasLogo) =>
        JsObject(
          "versions" -> versions.toJson,
          "metadata" -> metadata.toJson,
          "hasLogo" -> hasLogo.toJson
        )
    }
  }
}


