package com.xebialabs.plugin.manager.service

import com.typesafe.config.{Config, ConfigFactory}
import com.xebialabs.plugin.manager._
import com.xebialabs.plugin.manager.repository.PluginsRepository
import com.xebialabs.plugin.manager.repository.nexus.NexusRepositoryConfig.ListMethod
import com.xebialabs.plugin.manager.repository.nexus.{NexusPluginRepository, NexusRepositoryConfig}
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService
import grizzled.slf4j.Logging

import scala.collection.mutable
import scala.language.postfixOps
import scala.util.{Failure, Success}


class LocalPluginService(config: Config)(implicit repositoryVersionService: RepositoryVersionService) extends PluginService with Logging {

  override val repositories: mutable.Map[String, PluginsRepository] =
    mutable.Map.empty ++ {
      PluginService.configuredRepositories(config).flatMap {
        case Success(repo) => List(repo.name -> repo)
        case Failure(ex) =>
          logger.warn(ex)
          List.empty
      }.toMap
    }

  override def addRepository(repository: PluginsRepository): Boolean = {
    repositories.get(repository.name).map(_ => false).getOrElse {
      logger.info(s"Adding new repository; '${repository.name}' -> $repository")
      this.repositories += repository.name -> repository
      this.pluginManagerInstance = updatePluginManager()
      true
    }
  }

  override def deleteRepository(name: String): Boolean = {
    repositories.get(name).exists { _ =>
      logger.info(s"Removing repository '$name'")
      repositories -= name
      this.pluginManagerInstance = updatePluginManager()
      true
    }
  }


  override def pluginManager: PluginManager = pluginManagerInstance

  private var pluginManagerInstance: PluginManager = updatePluginManager()

  private def updatePluginManager(): LocalPluginManager = new LocalPluginManager(repositories.collect {
    case (name, NexusPluginRepository(_, NexusRepositoryConfig(_, _, _, _, ListMethod.ByGroupId(groupId, _, _)), _)) =>
      name -> groupId
  }.toMap)

}

object LocalPluginService {
  def empty()(implicit repositoryVersionService: RepositoryVersionService) = new LocalPluginService(ConfigFactory.empty())
}