package com.xebialabs.plugin.manager.repository.config

import org.apache.pekko.actor.ActorSystem
import org.apache.pekko.http.scaladsl.model.headers.HttpCredentials
import org.apache.pekko.http.scaladsl.model.{HttpRequest, HttpResponse, Uri}
import org.apache.pekko.http.scaladsl.settings.ConnectionPoolSettings
import org.apache.pekko.http.scaladsl.{ClientTransport, Http}

import scala.concurrent.Future

abstract class PluginServerConfig(val uri: Uri, val credentials: HttpCredentials, val transport: ClientTransport = ClientTransport.TCP) {

  def serviceUri: Uri

  def settings(implicit system: ActorSystem): ConnectionPoolSettings = ConnectionPoolSettings(system).withTransport(transport)

  def httpRequest(req: HttpRequest)(implicit system: ActorSystem): Future[HttpResponse] =
    Http().singleRequest(req, settings = settings)
}
