/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.classloader;

import com.xebialabs.plugin.protocol.xlp.PluginURL;
import de.schlichtherle.truezip.file.TFile;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceFinder {
    private static final Logger logger = LoggerFactory.getLogger(ResourceFinder.class);

    ResourceFinder() {
    }

    public static URL findResourceInDirs(String path, Iterable<TFile> dirs) throws MalformedURLException {
        String[] pathElements = path.split("/");
        for (TFile dir : dirs) {
            URL potentiallyNull;
            logger.trace("Scanning {} for {}", (Object)dir, (Object)pathElements);
            if (!dir.isDirectory() || (potentiallyNull = ResourceFinder.findResourceInDir(pathElements, dir, 0)) == null) continue;
            return potentiallyNull;
        }
        return null;
    }

    private static URL findResourceInDir(String[] pathElements, TFile dir, int pathIndex) throws MalformedURLException {
        for (TFile tFile : dir.listFiles()) {
            URL resourceInDir;
            logger.trace("Scanning {} for {} with index {}", new Object[]{tFile, pathElements, pathIndex});
            if (tFile.isArchive()) {
                resourceInDir = ResourceFinder.findResourceInDir(pathElements, tFile, 0);
                if (resourceInDir == null) continue;
                return resourceInDir;
            }
            if (tFile.isDirectory()) {
                if (!pathElements[pathIndex].equals(tFile.getName())) continue;
                if (pathElements.length == pathIndex + 1) {
                    return PluginURL.apply(tFile);
                }
                resourceInDir = ResourceFinder.findResourceInDir(pathElements, tFile, pathIndex + 1);
                if (resourceInDir == null) continue;
                return resourceInDir;
            }
            if (!pathElements[pathIndex].equals(tFile.getName()) || pathElements.length != pathIndex + 1) continue;
            return PluginURL.apply(tFile);
        }
        return null;
    }
}

