package com.xebialabs.plugin.zip

import java.io.{FilenameFilter, File}

trait PluginScanner {

  protected def findAllPluginFiles(pluginFolder: File, pluginExtension : String): Array[File] = pluginFolder.listFiles(new FilenameFilter {
    override def accept(dir: File, name: String): Boolean = s".+\\.$pluginExtension".r.findFirstIn(name).isDefined
  })

}