package com.xebialabs.platform.script.jython

import javax.script.ScriptException

import org.python.core.PySyntaxError

object JythonException {
  def apply(scriptSource: ScriptSource, ex: ScriptException): JythonException = {
    val origin: String = scriptSource match {
      case sc: ContentScriptSource => "jython-expression"
      case sc: UrlScriptSource => sc.url.toString
      case sc: ResourceScriptSource => sc.resource
    }
    val message = s"Error while executing script [$origin]: ${ex.getMessage}"
    ex.getCause match {
      case cause: PySyntaxError => new JythonSyntaxException(message, ex)
      case _ => new JythonException(message, ex)
    }
  }
}

class JythonException(message: String = null, cause: Exception = null) extends Exception(message, cause)

class JythonSyntaxException(message: String = null, cause: Exception = null) extends JythonException(message, cause)
