package com.xebialabs.platform.script.jython

import java.io.{IOException, Writer}

/**
 * Since there is an unexpected behaviour when running multiple script engines in parallel : http://bugs.jython.org/issue2154
 * We have to resort to a StringWriter sub-class which delegates to a StringWriter found using a ThreadLocal container.
 *
 * MW=20170712: The issue referenced above is marked resolved, but our tests still indicate the problem is not fixed.
 */
class ThreadLocalWriterDecorator() extends Writer {

  val threadLocal: ThreadLocal[Writer] = new ThreadLocal[Writer]

  def registerWriter(writer: Writer) {
    threadLocal.set(writer)
  }

  def removeWriter() = threadLocal.remove()

  def getWriter: Writer = threadLocal.get

  @throws(classOf[IOException])
  def write(cbuf: Array[Char], off: Int, len: Int) {
    getWriter.write(cbuf, off, len)
  }

  @throws(classOf[IOException])
  def flush() = getWriter.flush()


  @throws(classOf[IOException])
  def close() = getWriter.close()

  override def toString = getWriter.toString
}
