package com.xebialabs.deployit.security;

import java.util.List;

import org.springframework.security.core.Authentication;

/**
 * Reads roles from the repository and allows editing. The ordinary {@code getSomething()} methods return Roles <i>without</i> the assigned principals.
 * Only {@link #readRoleAssignments()} will a return a list with Role objects that also contain the principals.
 *
 * To edit the roles, first get a local copy of everything using {@link #readRoleAssignments()}, then write them all back with {@link #writeRoleAssignments(List)}.
 */
public interface RoleService {

    //
    // Simple getters
    //

    List<Role> getRoles();

    List<Role> getRolesFor(String principal);

    List<Role> getRolesFor(Authentication auth);

    Role getRoleForRoleName(String roleName);

    //
    // Edit methods
    //

    List<Role> readRoleAssignments();

    void writeRoleAssignments(List<Role> roles);

}
