package com.xebialabs.deployit.security;

import java.util.ArrayList;
import java.util.List;

import static java.util.Arrays.asList;

public class Team extends Role {

    private List<String> roles = new ArrayList<>();

    public Team(final String name) {
        this(null, name);
    }

    public Team(final String id, final String name) {
        super(id, name);
    }

    public Team(final String id, final String name, final List<String> roles, final List<String> principals) {
        super(id, name);
        setRoles(roles);
        setPrincipals(principals);
    }

    public Team withPrincipals(String... newPrincipals) {
        setPrincipals(new ArrayList<>(asList(newPrincipals)));
        return this;
    }

    public Team withRoles(String... newRoles) {
        setRoles(new ArrayList<>(asList(newRoles)));
        return this;
    }

    ////

    public List<String> getRoles() {
        return roles;
    }

    public void setRoles(final List<String> roles) {
        this.roles = roles;
    }
}
