/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.security.sql;

import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.RepoUser;
import com.xebialabs.deployit.security.SHA256PasswordEncoder;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.authentication.UserAlreadyExistsException;
import com.xebialabs.xlplatform.repository.sql.Database;
import com.xebialabs.xlplatform.security.sql.db.Tables;
import com.xebialabs.xlplatform.security.sql.db.Tables$;
import com.xebialabs.xlplatform.security.sql.package$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import slick.ast.BaseTypedType;
import slick.ast.TypedCollectionTypeConstructor$;
import slick.ast.TypedType;
import slick.dbio.DBIOAction;
import slick.dbio.DBIOAction$;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcProfile;
import slick.lifted.BaseColumnExtensionMethods;
import slick.lifted.CanBeQueryCondition$;
import slick.lifted.LiteralColumn;
import slick.lifted.OptionMapper2$;
import slick.lifted.Query;
import slick.lifted.Rep;
import slick.lifted.Shape$;
import slick.lifted.StringColumnExtensionMethods$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005h\u0001\u0002\f\u0018\u0001\tB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\u0006\u0005\u0002!\ta\u0011\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0011\u0019\t\u0006\u0001)A\u0005\u0013\"9!\u000b\u0001b\u0001\n\u0013\u0019\u0006BB,\u0001A\u0003%A\u000bC\u0004Y\u0001\t\u0007I\u0011B-\t\ru\u0003\u0001\u0015!\u0003[\u000b\u0011q\u0006\u0001A0\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 !9\u00111\u0006\u0001\u0005\n\u00055\u0002bBA\u001f\u0001\u0011%\u0011q\b\u0005\b\u0003S\u0002A\u0011IA6\u0011\u001d\t)\b\u0001C!\u0003oBq!a \u0001\t\u0003\n\t\tC\u0004\u0002\f\u0002!\t%!$\t\u000f\u0005-\u0005\u0001\"\u0011\u0002>\"9\u0011q\u0018\u0001\u0005B\u0005\u0005\u0007bBA`\u0001\u0011\u0005\u0013\u0011\u001a\u0005\b\u0003'\u0004A\u0011IAk\u0011\u001d\tI\u000e\u0001C!\u00037\u0014abU9m+N,'oU3sm&\u001cWM\u0003\u0002\u00193\u0005\u00191/\u001d7\u000b\u0005iY\u0012\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005qi\u0012A\u0003=ma2\fGOZ8s[*\u0011adH\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001I\u0001\u0004G>l7\u0001A\n\u0005\u0001\rZ#\u0007\u0005\u0002%S5\tQE\u0003\u0002'O\u0005!A.\u00198h\u0015\u0005A\u0013\u0001\u00026bm\u0006L!AK\u0013\u0003\r=\u0013'.Z2u!\ta\u0003'D\u0001.\u0015\tQbF\u0003\u00020;\u0005AA-\u001a9m_fLG/\u0003\u00022[\tYQk]3s'\u0016\u0014h/[2f!\t\u0019\u0004(D\u00015\u0015\t)d'A\u0003tY\u001a$$NC\u00018\u0003!9'/\u001b>{Y\u0016$\u0017BA\u001d5\u0005\u001daunZ4j]\u001e\f\u0001c]3dkJLG/\u001f#bi\u0006\u0014\u0017m]3\u0011\u0005q\u0002U\"A\u001f\u000b\u0005aq$BA \u001c\u0003)\u0011X\r]8tSR|'/_\u0005\u0003\u0003v\u0012\u0001\u0002R1uC\n\f7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u00113\u0005CA#\u0001\u001b\u00059\u0002\"\u0002\u001e\u0003\u0001\u0004Y\u0014a\u00029s_\u001aLG.Z\u000b\u0002\u0013B\u0011!jT\u0007\u0002\u0017*\u0011A*T\u0001\u0005U\u0012\u00147MC\u0001O\u0003\u0015\u0019H.[2l\u0013\t\u00016JA\u0006KI\n\u001c\u0007K]8gS2,\u0017\u0001\u00039s_\u001aLG.\u001a\u0011\u0002\u001fA\f7o]<pe\u0012,enY8eKJ,\u0012\u0001\u0016\t\u0003YUK!AV\u0017\u0003+MC\u0015IM\u001b7!\u0006\u001c8o^8sI\u0016s7m\u001c3fe\u0006\u0001\u0002/Y:to>\u0014H-\u00128d_\u0012,'\u000fI\u0001\u000f\u0015\u000e\u0013v,\u0011#N\u0013:{VkU#S+\u0005Q\u0006C\u0001\u0013\\\u0013\taVE\u0001\u0004TiJLgnZ\u0001\u0010\u0015\u000e\u0013v,\u0011#N\u0013:{VkU#SA\t\t\u0011\u000b\u0005\u0004aK.,\u00181\u0002\b\u0003C\u000et!AY\u0002\u000e\u0003\u0001I!\u0001Z(\u0002\u0007\u0005\u0004\u0018.\u0003\u0002gO\n)\u0011+^3ss&\u0011\u0001.\u001b\u0002\b\u00032L\u0017m]3t\u0015\tQW*\u0001\u0004mS\u001a$X\r\u001a\t\u0003YJt!!\u001c9\u000e\u00039T!a\\\f\u0002\u0005\u0011\u0014\u0017BA9o\u0003\u0019!\u0016M\u00197fg&\u00111\u000f\u001e\u0002\u0006+N,'o\u001d\u0006\u0003c:\u0004BA^=|w6\tqOC\u0001y\u0003\u0015\u00198-\u00197b\u0013\tQxO\u0001\u0004UkBdWM\r\t\u0004y\u0006\u001dabA?\u0002\u0004A\u0011ap^\u0007\u0002\u007f*\u0019\u0011\u0011A\u0011\u0002\rq\u0012xn\u001c;?\u0013\r\t)a^\u0001\u0007!J,G-\u001a4\n\u0007q\u000bIAC\u0002\u0002\u0006]\u0004B!!\u0004\u0002\u00189!\u0011qBA\n\u001d\rq\u0018\u0011C\u0005\u0002q&\u0019\u0011QC<\u0002\u000fA\f7m[1hK&!\u0011\u0011DA\u000e\u0005\r\u0019V-\u001d\u0006\u0004\u0003+9\u0018AE2iK\u000e\\g+\u00197jIV\u001bXM\u001d8b[\u0016$B!!\t\u0002(A\u0019a/a\t\n\u0007\u0005\u0015rO\u0001\u0003V]&$\bBBA\u0015\u0015\u0001\u000710\u0001\u0005vg\u0016\u0014h.Y7f\u0003-1\u0017\u000e\u001c;feV\u001bXM]:\u0015\r\u0005=\u0012QGA\u001e!!\t\t$a\rlk\u0006-Q\"A5\n\u0005\u0019L\u0007bBA\u001c\u0017\u0001\u0007\u0011\u0011H\u0001\u0006cV,'/\u001f\t\u0003E&Aa!!\u000b\f\u0001\u0004Y\u0018\u0001\u0003:fC\u0012,6/\u001a:\u0015\t\u0005\u0005\u0013q\r\t\u0006m\u0006\r\u0013qI\u0005\u0004\u0003\u000b:(AB(qi&|g\u000e\u0005\u0003\u0002J\u0005\rdbAA&a:!\u0011QJA1\u001d\u0011\ty%a\u0018\u000f\t\u0005E\u0013Q\f\b\u0005\u0003'\nYF\u0004\u0003\u0002V\u0005ecb\u0001@\u0002X%\t\u0001%\u0003\u0002\u001f?%\u0011A$H\u0005\u00035mI!\u0001G\r\n\u0005=<\u0012bAA3i\n!Qk]3s\u0011\u0019\tI\u0003\u0004a\u0001w\u0006Q1m\\;oiV\u001bXM]:\u0015\t\u00055\u00141\u000f\t\u0004m\u0006=\u0014bAA9o\n!Aj\u001c8h\u0011\u0019\tI#\u0004a\u0001w\u000611M]3bi\u0016$b!!\t\u0002z\u0005m\u0004BBA\u0015\u001d\u0001\u00071\u0010\u0003\u0004\u0002~9\u0001\ra_\u0001\ta\u0006\u001c8o^8sI\u0006!!/Z1e)\u0011\t\u0019)!#\u0011\u00071\n))C\u0002\u0002\b6\u0012\u0001BU3q_V\u001bXM\u001d\u0005\u0007\u0003Sy\u0001\u0019A>\u0002\u001b1L7\u000f^+tKJt\u0017-\\3t)!\ty)a'\u0002\u001e\u0006M\u0006#BAI\u0003/[XBAAJ\u0015\r\t)jJ\u0001\u0005kRLG.\u0003\u0003\u0002\u001a\u0006M%\u0001\u0002'jgRDa!!\u000b\u0011\u0001\u0004Y\bbBAP!\u0001\u0007\u0011\u0011U\u0001\u0007a\u0006<\u0017N\\4\u0011\t\u0005\r\u0016qV\u0007\u0003\u0003KSA!a*\u0002*\u0006\u0019A\r^8\u000b\u0007\u0011\fYKC\u0002\u0002.:\na!\u001a8hS:,\u0017\u0002BAY\u0003K\u0013a\u0001U1hS:<\u0007bBA[!\u0001\u0007\u0011qW\u0001\u0006_J$WM\u001d\t\u0005\u0003G\u000bI,\u0003\u0003\u0002<\u0006\u0015&\u0001C(sI\u0016\u0014\u0018N\\4\u0015\u0005\u0005=\u0015AD7pI&4\u0017\u0010U1tg^|'\u000f\u001a\u000b\u0007\u0003C\t\u0019-!2\t\r\u0005%\"\u00031\u0001|\u0011\u0019\t9M\u0005a\u0001w\u0006Ya.Z<QCN\u001cxo\u001c:e)!\t\t#a3\u0002N\u0006=\u0007BBA\u0015'\u0001\u00071\u0010\u0003\u0004\u0002HN\u0001\ra\u001f\u0005\u0007\u0003#\u001c\u0002\u0019A>\u0002\u0017=dG\rU1tg^|'\u000fZ\u0001\u0007I\u0016dW\r^3\u0015\t\u0005\u0005\u0012q\u001b\u0005\u0007\u0003S!\u0002\u0019A>\u0002\u0019\u0005,H\u000f[3oi&\u001c\u0017\r^3\u0015\r\u0005\u0005\u0012Q\\Ap\u0011\u0019\tI#\u0006a\u0001w\"1\u0011QP\u000bA\u0002m\u0004")
public class SqlUserService
implements UserService,
Logging {
    private final Database securityDatabase;
    private final JdbcProfile profile;
    private final SHA256PasswordEncoder passwordEncoder;
    private final String JCR_ADMIN_USER;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlUserService sqlUserService = this;
        synchronized (sqlUserService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public JdbcProfile profile() {
        return this.profile;
    }

    private SHA256PasswordEncoder passwordEncoder() {
        return this.passwordEncoder;
    }

    private String JCR_ADMIN_USER() {
        return this.JCR_ADMIN_USER;
    }

    private void checkValidUsername(String username) {
        if (username == null || username.length() == 0) {
            throw new IllegalArgumentException("Username can neither be null nor empty.");
        }
        Option<Tuple2<String, String>> option = this.readUser(username);
        if (option instanceof Some) {
            throw new UserAlreadyExistsException(username);
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Query<Tables.Users, Tuple2<String, String>, Seq> filterUsers(Query<Tables.Users, Tuple2<String, String>, Seq> query, String username2) {
        return (Query)Option$.MODULE$.apply((Object)username2).map((Function1 & Serializable)username -> query.filter((Function1 & Serializable)x$1 -> {
            Rep qual$1 = this.profile().api().stringColumnExtensionMethods(StringColumnExtensionMethods$.MODULE$.toLowerCase$extension(this.profile().api().stringColumnExtensionMethods(x$1.username())));
            LiteralColumn x$12 = this.profile().api().valueToConstColumn((Object)("%" + username.toLowerCase() + "%"), (TypedType)this.profile().api().stringColumnType());
            char x$2 = StringColumnExtensionMethods$.MODULE$.like$default$2$extension(qual$1);
            return StringColumnExtensionMethods$.MODULE$.like$extension(qual$1, (Rep)x$12, x$2, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().stringColumnType()));
        }, CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition())).getOrElse((Function0 & Serializable)() -> query);
    }

    private Option<Tuple2<String, String>> readUser(String username) {
        return ((IterableOps)this.securityDatabase.runAwait((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(Tables$.MODULE$.users().filter((Function1 & Serializable)x$2 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(StringColumnExtensionMethods$.MODULE$.toLowerCase$extension(this.profile().api().stringColumnExtensionMethods(x$2.username())), (BaseTypedType)this.profile().api().stringColumnType())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)username.toLowerCase(), (TypedType)this.profile().api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)user -> new Tuple2(user.username(), user.password()), Shape$.MODULE$.tuple2Shape(Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType()), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType()))))).result())).headOption();
    }

    public long countUsers(String username) {
        return BoxesRunTime.unboxToInt((Object)this.securityDatabase.runAwait((DBIOAction)((JdbcActionComponent.QueryActionExtensionMethodsImpl)this.profile().api().recordQueryActionExtensionMethods((Object)this.filterUsers((Query<Tables.Users, Tuple2<String, String>, Seq>)Tables$.MODULE$.users(), username).length(), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().intColumnType()))).result()));
    }

    public void create(String username, String password) {
        this.checkValidUsername(username);
        String pwd = this.passwordEncoder().encode((CharSequence)password);
        this.securityDatabase.runAwait(DBIOAction$.MODULE$.seq((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DBIOAction[]{((JdbcActionComponent.SimpleInsertActionComposer)this.profile().api().queryInsertActionExtensionMethods(Tables$.MODULE$.users())).$plus$eq((Object)new Tuple2((Object)username, (Object)pwd))})));
    }

    public RepoUser read(String username) {
        return (RepoUser)this.readUser(username).map((Function1 & Serializable)user -> new RepoUser((String)user._1(), this.JCR_ADMIN_USER().equals(user._1()))).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("No such user: " + username, new Object[0]);
        });
    }

    public java.util.List<String> listUsernames(String username, Paging paging, Ordering order) {
        List filters = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)query -> this.filterUsers((Query<Tables.Users, Tuple2<String, String>, Seq>)query, username), (Function1 & Serializable)query -> order == null || order.isAscending() ? query.sortBy((Function1 & Serializable)x$3 -> this.profile().api().columnToOrdered(StringColumnExtensionMethods$.MODULE$.toLowerCase$extension(this.profile().api().stringColumnExtensionMethods(x$3.username())), (TypedType)this.profile().api().stringColumnType()).asc(), Predef$.MODULE$.$conforms()) : query.sortBy((Function1 & Serializable)x$4 -> this.profile().api().columnToOrdered(StringColumnExtensionMethods$.MODULE$.toLowerCase$extension(this.profile().api().stringColumnExtensionMethods(x$4.username())), (TypedType)this.profile().api().stringColumnType()).desc(), Predef$.MODULE$.$conforms()), (Function1 & Serializable)query -> paging == null ? query : query.drop((paging.page() - 1) * paging.resultsPerPage()).take(paging.resultsPerPage())}));
        return package$.MODULE$.ListExtensions(((IterableOnceOps)this.securityDatabase.runAwait((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(((Query)filters.foldLeft((Object)Tables$.MODULE$.users().to(TypedCollectionTypeConstructor$.MODULE$.forColl(Seq$.MODULE$.iterableFactory(), ClassTag$.MODULE$.apply(Seq.class))), (Function2 & Serializable)(acc, filter) -> (Query)filter.apply(acc))).map((Function1 & Serializable)x$5 -> x$5.username(), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType())))).result())).toList()).asJavaMutable();
    }

    public java.util.List<String> listUsernames() {
        return package$.MODULE$.ListExtensions(((IterableOnceOps)this.securityDatabase.runAwait((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(Tables$.MODULE$.users().map((Function1 & Serializable)x$6 -> x$6.username(), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType())))).result())).toList()).asJavaMutable();
    }

    public void modifyPassword(String username, String newPassword) {
        this.securityDatabase.runAwait((DBIOAction)this.profile().api().queryUpdateActionExtensionMethods(Tables$.MODULE$.users().filter((Function1 & Serializable)x$7 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$7.username(), (BaseTypedType)this.profile().api().stringColumnType())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)username, (TypedType)this.profile().api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)x$8 -> x$8.password(), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType()))).update((Object)this.passwordEncoder().encode((CharSequence)newPassword)));
    }

    public void modifyPassword(String username, String newPassword, String oldPassword) {
        this.readUser(username).foreach((Function1 & Serializable)user -> {
            SqlUserService.$anonfun$modifyPassword$3(this, oldPassword, username, newPassword, user);
            return BoxedUnit.UNIT;
        });
    }

    public void delete(String username) {
        this.securityDatabase.runAwait((DBIOAction)this.profile().api().queryDeleteActionExtensionMethods(Tables$.MODULE$.users().filter((Function1 & Serializable)x$9 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$9.username(), (BaseTypedType)this.profile().api().stringColumnType())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)username, (TypedType)this.profile().api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition())).delete());
    }

    public void authenticate(String username, String password) {
        Tuple2 user = (Tuple2)this.readUser(username).getOrElse((Function0 & Serializable)() -> {
            throw new AuthenticationFailureException("Cannot authenticate " + username);
        });
        if (!this.passwordEncoder().matches((CharSequence)password, (String)user._2())) {
            throw new AuthenticationFailureException("Wrong credentials supplied for user " + username);
        }
    }

    public static final /* synthetic */ void $anonfun$modifyPassword$3(SqlUserService $this, String oldPassword$1, String username$6, String newPassword$1, Tuple2 user) {
        if (!$this.passwordEncoder().matches((CharSequence)oldPassword$1, (String)user._2())) {
            throw new IllegalArgumentException("Failed to change password: Old password does not match.");
        }
        $this.modifyPassword(username$6, newPassword$1);
    }

    public SqlUserService(Database securityDatabase) {
        this.securityDatabase = securityDatabase;
        Logging.$init$((Logging)this);
        this.profile = securityDatabase.config().databaseType().profile();
        this.passwordEncoder = new SHA256PasswordEncoder();
        this.JCR_ADMIN_USER = "admin";
    }
}

