/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.UserAlreadyExistsException;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.core.Authentication;

public abstract class UserServiceTest {
    private static String TEST_USERNAME = "test-user";
    private static String TEST_PASSWORD = "initial-password-for-test-user";
    private static String MODIFIED_TEST_PASSWORD = "modified-password-for-test-user";
    private UserService userService;
    private Authentication originalAuthentication;

    protected abstract UserService getUserService();

    @Before
    public void setupUserService() throws IllegalAccessException {
        this.userService = this.getUserService();
    }

    @Before
    public void authenticateAsAdmin() {
        this.originalAuthentication = SecurityTemplate.setCredentials((String)"admin", (String)"admin");
    }

    @After
    public void restoreOriginalAuthentication() {
        SecurityTemplate.restoreAuthentication((Authentication)this.originalAuthentication);
    }

    @Test
    public void canReadAdminUser() {
        User adminUser = this.userService.read("admin");
        Assert.assertThat((Object)adminUser, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)adminUser.getUsername(), (Matcher)CoreMatchers.is((Object)"admin"));
        Assert.assertThat((Object)adminUser.isAdmin(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldCreateModifyAndDeleteUser() {
        this.shouldCreateUser();
        this.shouldModifyPasswordOfUser();
        this.shouldDeleteUser();
    }

    @Test
    public void shouldListUsernames() {
        this.userService.create(TEST_USERNAME + "-1", TEST_PASSWORD);
        this.userService.create(TEST_USERNAME + "-2", TEST_PASSWORD);
        List usernames = this.userService.listUsernames();
        Assert.assertThat((Object)usernames, (Matcher)CoreMatchers.hasItems((Object[])new String[]{TEST_USERNAME + "-1", TEST_USERNAME + "-2", "admin"}));
        Assert.assertThat((Object)usernames, (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void shouldModifyPasswordsProvidingTheOldOne() {
        this.shouldCreateUser();
        this.shouldRejectModifyingPasswordWhenPreviousIsWrong();
        this.shouldModifyPasswordWhenProvidingPrevious();
        this.shouldDeleteUser();
    }

    @Test(expected=UserAlreadyExistsException.class)
    public void shouldRejectCreatingSameUserTwice() {
        this.userService.create("Paul", TEST_PASSWORD);
        this.userService.create("Paul", TEST_PASSWORD);
    }

    @Test(expected=UserAlreadyExistsException.class)
    public void shouldRejectCreatingSameUserWithDifferentCaseTwice() {
        this.userService.create("Vanya", TEST_PASSWORD);
        this.userService.create("Vanya".toUpperCase(), TEST_PASSWORD);
    }

    public void shouldCreateUser() {
        this.assertTestUserDoesNotExist();
        this.userService.create(TEST_USERNAME, TEST_PASSWORD);
        this.assertTestUserDoesExist();
        this.assertTestUserCanLogin();
    }

    public void shouldModifyPasswordOfUser() {
        this.userService.modifyPassword(TEST_USERNAME, MODIFIED_TEST_PASSWORD);
        this.assertTestUserCanLogin();
    }

    public void shouldModifyPasswordWhenProvidingPrevious() {
        this.userService.modifyPassword(TEST_USERNAME, MODIFIED_TEST_PASSWORD, TEST_PASSWORD);
        this.assertTestUserCanLogin();
    }

    public void shouldRejectModifyingPasswordWhenPreviousIsWrong() {
        Exception caughtException = null;
        try {
            this.userService.modifyPassword(TEST_USERNAME, MODIFIED_TEST_PASSWORD, MODIFIED_TEST_PASSWORD);
        }
        catch (Exception exception) {
            caughtException = exception;
        }
        Assert.assertThat((Object)caughtException, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)caughtException, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class)));
        Assert.assertThat((Object)caughtException.getMessage(), (Matcher)CoreMatchers.containsString((String)"Failed to change password: Old password does not match."));
    }

    public void shouldDeleteUser() {
        Assert.assertThat((Object)this.userService.read(TEST_USERNAME), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.userService.delete(TEST_USERNAME);
        this.assertTestUserDoesNotExist();
    }

    private void assertTestUserDoesNotExist() {
        try {
            this.userService.read(TEST_USERNAME);
            Assert.fail((String)("Did not expect to read user " + TEST_USERNAME));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void assertTestUserDoesExist() {
        User foundUser = this.userService.read(TEST_USERNAME);
        Assert.assertThat((Object)foundUser, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)foundUser.getUsername(), (Matcher)CoreMatchers.is((Object)TEST_USERNAME));
        Assert.assertThat((Object)foundUser.isAdmin(), (Matcher)CoreMatchers.is((Object)false));
    }

    protected abstract void assertTestUserCanLogin();
}

