package com.xebialabs.deployit.security.permission;

import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.SecurityServiceLocator;

public class ReadPermissionHandler extends PermissionHandler {

    public ReadPermissionHandler() {
        super(PlatformPermissions.READ);
    }

    @Override
    public boolean hasPermission(String onConfigurationItem) {
        PermissionEnforcer permissionEnforcer = SecurityServiceLocator.getPermissionEnforcer();
        return permissionEnforcer.hasLoggedInUserPermission(Permission.getReadPermissions(), onConfigurationItem);
    }
}
