/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.permission;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Permission {
    private static final Map<String, Permission> REGISTERED_PERMISSIONS = new LinkedHashMap<String, Permission>();
    private static final List<Permission> IMPLICIT_READ_PERMISSIONS = new ArrayList<Permission>();
    private static final String GLOBAL_SECURITY_ALIAS = "global";
    private final String permissionName;
    private final PermissionHandler.Level level;
    private final PermissionHandler permissionHandler;
    private final Metadata.ConfigurationItemRoot root;

    private Permission(String permissionName, PermissionHandler.Level level, PermissionHandler permissionHandler, Metadata.ConfigurationItemRoot root) {
        this.permissionName = permissionName;
        this.level = level;
        this.root = root;
        this.permissionHandler = permissionHandler != null ? permissionHandler : new PermissionHandler(this);
    }

    public static Permission definePermission(String name, PermissionHandler.Level level) {
        Permission permission = new Permission(name, level, null, null);
        Permission.registerPermission(permission, false);
        return permission;
    }

    public static Permission definePermission(String name, PermissionHandler.Level level, PermissionHandler handler, boolean implicitRead) {
        Permission permission = new Permission(name, level, handler, null);
        Permission.registerPermission(permission, implicitRead);
        return permission;
    }

    public static Permission definePermission(String name, PermissionHandler.Level level, Metadata.ConfigurationItemRoot root) {
        return Permission.definePermission(name, level, root, false);
    }

    public static Permission definePermission(String name, PermissionHandler.Level level, Metadata.ConfigurationItemRoot root, boolean implicitRead) {
        Permission permission = new Permission(name, level, null, root);
        Permission.registerPermission(permission, implicitRead);
        return permission;
    }

    private static void registerPermission(Permission permission, boolean implicitRead) {
        REGISTERED_PERMISSIONS.put(permission.getPermissionName(), permission);
        if (implicitRead) {
            IMPLICIT_READ_PERMISSIONS.add(permission);
        }
    }

    public static Permission find(String permissionName) {
        return REGISTERED_PERMISSIONS.get(permissionName);
    }

    public static Collection<Permission> getAll() {
        return REGISTERED_PERMISSIONS.values();
    }

    public static List<Permission> getReadPermissions() {
        return Collections.unmodifiableList(IMPLICIT_READ_PERMISSIONS);
    }

    public PermissionHandler getPermissionHandler() {
        return this.permissionHandler;
    }

    public String getPermissionName() {
        return this.permissionName;
    }

    public PermissionHandler.Level getLevel() {
        return this.level;
    }

    public Metadata.ConfigurationItemRoot getRoot() {
        return this.root;
    }

    public boolean isApplicableTo(String id) {
        boolean idIsGlobal;
        id = id != null ? id : "";
        boolean bl = idIsGlobal = id.isEmpty() || id.equals(GLOBAL_SECURITY_ALIAS);
        if (this.level == PermissionHandler.Level.GLOBAL && idIsGlobal) {
            return true;
        }
        if (this.level == PermissionHandler.Level.BOTH && idIsGlobal) {
            return true;
        }
        if (this.level == PermissionHandler.Level.CI && idIsGlobal) {
            return false;
        }
        if (this.level != PermissionHandler.Level.BOTH && this.level != PermissionHandler.Level.CI) {
            return false;
        }
        if (this.root == null) {
            return true;
        }
        return id.startsWith(this.root.getRootNodeName());
    }

    public boolean equals(Object other) {
        if (other instanceof Permission) {
            return this.permissionName.equals(((Permission)other).permissionName);
        }
        return false;
    }

    public int hashCode() {
        return this.permissionName.hashCode();
    }

    public String toString() {
        if (this.level != PermissionHandler.Level.GLOBAL && this.root != null) {
            return this.permissionName + " on " + this.root;
        }
        return this.permissionName;
    }
}

