/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.authentication;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.Transient;
import org.springframework.util.Assert;

@Transient
public class PersonalAuthenticationToken
extends AbstractAuthenticationToken {
    private final Object principal;
    private String token;
    private final Set<String> globalPermissions;
    private final Set<String> configurationItemsPermissions;
    private final Set<String> configurationItems;

    public PersonalAuthenticationToken(String token) {
        super(Collections.emptyList());
        Assert.hasText((String)token, (String)"token cannot be empty");
        this.principal = null;
        this.token = token;
        this.globalPermissions = Collections.unmodifiableSet(Collections.emptySet());
        this.configurationItemsPermissions = Collections.unmodifiableSet(Collections.emptySet());
        this.configurationItems = Collections.unmodifiableSet(Collections.emptySet());
        this.setAuthenticated(false);
    }

    public PersonalAuthenticationToken(Object principal, String token, Collection<? extends GrantedAuthority> authorities, Set<String> globalPermissions, Set<String> configurationItemsPermissions, Set<String> configurationItems) {
        super(authorities);
        this.principal = principal;
        this.token = token;
        this.globalPermissions = Collections.unmodifiableSet(globalPermissions);
        this.configurationItemsPermissions = Collections.unmodifiableSet(configurationItemsPermissions);
        this.configurationItems = Collections.unmodifiableSet(configurationItems);
        this.setAuthenticated(true);
    }

    public Object getCredentials() {
        return this.token;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public void eraseCredentials() {
        super.eraseCredentials();
        this.token = null;
    }

    public Set<String> getGlobalPermissions() {
        return this.globalPermissions;
    }

    public Set<String> getConfigurationItemsPermissions() {
        return this.configurationItemsPermissions;
    }

    public Set<String> getConfigurationItems() {
        return this.configurationItems;
    }

    public boolean isLegacyToken() {
        return this.globalPermissions.isEmpty() && this.configurationItemsPermissions.isEmpty();
    }
}

