package com.xebialabs.xlplatform.test.sql

import javax.sql.DataSource

import com.xebialabs.xlplatform.repository.sql.{Database, DatabaseConfig, DatabaseType}
import org.scalatest.{BeforeAndAfterAll, BeforeAndAfterEach, Suite}

trait SlickSupport extends BeforeAndAfterAll with BeforeAndAfterEach {
  self: Suite =>

  implicit val dataSource: DataSource

  var dbType: DatabaseType.H2.type = DatabaseType.H2

  lazy val database: Database = Database(dataSource, DatabaseConfig(dbType, "test"))
}
