package com.xebialabs.xlplatform.test.sql

import java.sql.Connection
import javax.sql.DataSource

import liquibase.Liquibase
import liquibase.database.DatabaseFactory
import liquibase.database.jvm.JdbcConnection
import liquibase.resource.ClassLoaderResourceAccessor
import org.scalatest.{BeforeAndAfterAll, BeforeAndAfterEach, Suite}

trait LiquibaseSupport extends BeforeAndAfterAll with BeforeAndAfterEach {
  self: Suite =>
  implicit val dataSource: DataSource

  def changeLogFile(): String = {
    "db/testSchema.yaml"
  }

  def init(): Unit = {
    doWithLiquibase { liquibase =>
      liquibase.update("")
    }
  }

  def dropAll(): Unit = {
    doWithLiquibase { liquibase =>
      liquibase.dropAll()
    }
  }

  private def doWithLiquibase(callback: (Liquibase) => Unit): Unit = {
    val connection: Connection = dataSource.getConnection
    try {
      val database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection))
      val liquibase = new Liquibase(changeLogFile(), new ClassLoaderResourceAccessor(), database)
      callback(liquibase)
    } finally {
      connection.close()
    }
  }

  override protected def beforeAll(): Unit = {
    super.beforeAll()
    init()
  }

  override protected def afterAll(): Unit = {
    dropAll()
    super.afterAll()
  }
}
