package com.xebialabs.xlplatform.test.jackrabbit;

import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.repository.JcrRepositoryService;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlplatform.repository.JcrRepositoryMetadataService;
import com.xebialabs.xlplatform.test.ci.CiHelper;
import com.xebialabs.xlplatform.test.jcr.JcrTestHelper;

public abstract class JackrabbitTestBase {

    protected static JcrTestHelper jcrTestHelper;
    protected static JcrTemplate jcrTemplate;
    protected static PasswordEncrypter passwordEncrypter;
    protected static JcrRepositoryService repositoryService;
    protected static JcrRepositoryMetadataService jcrRepositoryMetadataService;
    protected static CiHelper ciHelper;

    @org.junit.BeforeClass
    @org.testng.annotations.BeforeClass
    public static void initJackrabbitRepository() {
        try {
            LocalBooter.bootWithoutGlobalContext();
            jcrTestHelper = new JcrTestHelper();
            jcrTestHelper.setupRepository(new TestJackrabbitRepositoryBooter(), new TestJackrabbitRepositoryConfig());
            jcrTemplate = jcrTestHelper.getJcrTemplate();
            passwordEncrypter = PasswordEncrypter.getInstance();
            repositoryService = jcrTestHelper.getRepositoryService();
            jcrRepositoryMetadataService = new JcrRepositoryMetadataService(jcrTemplate);
            new RepositoryServiceHolder(repositoryService);
            ciHelper = new CiHelper(repositoryService);
        } catch (Exception e) {
            throw new RuntimeException("Could not boot test setup", e);
        }
    }

    @org.junit.AfterClass
    @org.testng.annotations.AfterClass
    public static void shutdownJcrRepository() {
        jcrTestHelper.cleanupRepository();
        jcrTestHelper.shutdownRepository();
        new RepositoryServiceHolder(null);

        System.gc();
    }

}
