package com.xebialabs.xlplatform.test.jackrabbit;

import java.util.function.Consumer;
import org.junit.rules.ExternalResource;

import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.repository.JcrRepositoryService;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlplatform.repository.JcrRepositoryMetadataService;
import com.xebialabs.xlplatform.test.ci.CiHelper;
import com.xebialabs.xlplatform.test.jcr.JcrTestHelper;

public class JackrabbitTestRule extends ExternalResource {

    public JcrTestHelper jcrTestHelper;
    public JcrTemplate jcrTemplate;
    public PasswordEncrypter passwordEncrypter;
    public JcrRepositoryService repositoryService;
    public JcrRepositoryMetadataService jcrRepositoryMetadataService;
    public CiHelper ciHelper;

    private Consumer<JackrabbitTestRule> extraInitialization;

    public JackrabbitTestRule() {
    }

    public JackrabbitTestRule(Consumer<JackrabbitTestRule> extraInitialization) {
        this.extraInitialization = extraInitialization;
    }

    @Override
    public void before() throws Exception {
        try {
            LocalBooter.bootWithoutGlobalContext();
            jcrTestHelper = new JcrTestHelper();
            jcrTestHelper.setupRepository(new TestJackrabbitRepositoryBooter(), new TestJackrabbitRepositoryConfig());
            jcrTemplate = jcrTestHelper.getJcrTemplate();
            passwordEncrypter = PasswordEncrypter.getInstance();
            repositoryService = jcrTestHelper.getRepositoryService();
            jcrRepositoryMetadataService = new JcrRepositoryMetadataService(jcrTemplate);
            new RepositoryServiceHolder(repositoryService);
            ciHelper = new CiHelper(repositoryService);
            if (extraInitialization != null) {
                extraInitialization.accept(this);
            }
        } catch (Exception e) {
            throw new RuntimeException("Could not boot test setup", e);
        }
    }

    @Override
    public void after() {
        jcrTestHelper.cleanupRepository();
        jcrTestHelper.shutdownRepository();
        new RepositoryServiceHolder(null);

        System.gc();
    }
}
