package com.xebialabs.xlplatform.sugar

import com.xebialabs.xlplatform.utils.ClassLoaderUtils.classLoader

import java.io.InputStream
import java.net.URL
import scala.jdk.CollectionConverters._

trait ResourcesSugar {
  def resource(fileResource: String): URL = Option(classLoader.getResource(fileResource)).getOrElse(notFound(fileResource))

  def resources(fileResource: String): Iterable[URL] = classLoader.getResources(fileResource).asScala.to(Iterable)

  def resourceAsInputStream(fileResource:String): InputStream =
    Option(classLoader.getResourceAsStream(fileResource)).getOrElse(notFound(fileResource))

  private def notFound(classpathResource: String) =
    throw new IllegalArgumentException(s"Classpath resource $classpathResource not found")
}
