package com.xebialabs.xltest.jmeter;

public class Summary {
    private final long startTime;
    private final long endTime;
    private final String name;
    private final String failureMessage;
    private final int errors;

    public Summary(long startTime, long endTime, int errors, String name, String failureMessage) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.errors = errors;
        this.name = name;
        this.failureMessage = failureMessage;
    }

    public Summary(long startTime, long endTime, int errors) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.errors = errors;
        this.name = null;
        this.failureMessage = null;
    }

    public long getStartTime() {
        return startTime;
    }

    public long getEndTime() {
        return endTime;
    }

    public String getName() {
        return name;
    }

    public String getFailureMessage() {
        return failureMessage;
    }

    @Override
    public String toString() {
        return "{" +
                "\"type\":\"result:jmeter\"" +
                ",\"startTime\":" + startTime +
                ",\"endTime\":" + endTime +
                ",\"name\":\"" + name +
                "\",\"failureMessage\":\"" + failureMessage +
                "\",\"errors\":" + errors +
                '}';
    }
}
