package com.xebialabs.xltest.jmeter;

import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.reporters.AbstractListenerElement;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class XLTestLogger extends AbstractListenerElement
        implements SampleListener, Serializable,
        NoThreadClone, TestStateListener {
    private static final Logger LOG = LoggingManager.getLoggerForClass();

    private Feedback<Object> feedback;

    public XLTestLogger() {
    }

    public XLTestLogger(Feedback<Object> feedback) {
        this.feedback = feedback;
    }

    @Override
    public synchronized void sampleOccurred(SampleEvent se) {
        SampleResult res = se.getResult();

        if (!res.isSuccessful()) {
            feedback.found(new Summary(
                    res.getStartTime(), res.getEndTime(), res.getErrorCount()));
            return;
        }

        AssertionResult[] assertions = res.getAssertionResults();
        if (assertions != null) {
            for (int i = 0; i < assertions.length; i++) {
                AssertionResult assertion = assertions[i];
                if (assertion.isError() || assertion.isFailure()) {
                    feedback.found(new Summary(
                            res.getStartTime(), res.getEndTime(), res.getErrorCount(),
                            assertion.getName(), assertion.getFailureMessage()));
                    return;
                }
            }
        }
    }

    @Override
    public void sampleStarted(SampleEvent se) {
    }

    @Override
    public void sampleStopped(SampleEvent se) {
    }

    @Override
    public void testStarted() {
        feedback = getFeedback();
        // TODO: Launch sender thread
        feedback.found(new TestStarted(System.currentTimeMillis()));
    }

    @Override
    public void testStarted(String string) {
        testStarted();
    }

    @Override
    public void testEnded() {
        feedback.found(new TestEnded(System.currentTimeMillis()));
        // TODO:kill sender thread
    }

    @Override
    public void testEnded(String string) {
        testEnded();
    }

    @Override
    public Object clone() {
        XLTestLogger o = (XLTestLogger) super.clone();
        o.feedback = this.feedback;
        return o;
    }

    private Feedback getFeedback() {
        if (this.feedback != null) {
            return this.feedback;
        }

        Feedback feedback;
        String xltestUrl = getXlTestUrl();
        if (xltestUrl != null) {
            try {
                feedback = new FeedbackEventSender(new URL(xltestUrl));
            } catch (MalformedURLException e) {
                LOG.error("Unable to create feedback sender: invalid url", e);
                feedback = new FeedbackLogger();
            }
        } else {
            feedback = new FeedbackLogger();
        }
        return feedback;
    }

    public static String getXlTestUrl() {
        return System.getenv("XLTEST_URL");
    }
}