package com.xebialabs.xltest.domain;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

@SuppressWarnings("serial")
@Metadata(description = "DB2 store", root = Metadata.ConfigurationItemRoot.CONFIGURATION)
public class DB2Store extends SQLStore {
	private static final Logger LOG = LoggerFactory.getLogger(DB2Store.class);
	private static final String RUN_ID_FIELD = "run_id";

	static {
		try {
			Class.forName("com.ibm.db2.jcc.DB2Driver");
		} catch (ClassNotFoundException e) {
			// No such driver
		}
	}
	
	public DB2Store() {
	}

	public DB2Store(String url, String username, String password, String tablename) {
		super(url, username, password, tablename);
	}
	
	@Override
	public String createInsertIntoTableString(Event event) {
		String statementString = "insert into " + getTablename() + "(" + columnDefinitionsAsString() + ") values (" + makeQuestionMarks() + ");";
		return statementString;
	}
	
	@Override
	public String columnDefinitionsAsString() {
		// like: testset, result, team
		StringBuilder sb = new StringBuilder();
		if (!getPropertyTypeMap().keySet().isEmpty()) {
			for (String columnname : getOrderedKeys()) {
				sb.append("\"");
				sb.append(columnname);
				sb.append("\", ");
			}
		}
		String columnDefs = sb.toString();
		if (columnDefs.length() > 2) {
			columnDefs = columnDefs.substring(0, columnDefs.length() - 2);
		}
		return columnDefs;
	}

	@Override
	public String createColumnDefinitionsAsString() {
		// like: ( testset varchar(255), result varchar(255), team varchar(255));
		StringBuilder sb = new StringBuilder();
		if (!getPropertyTypeMap().keySet().isEmpty()) {
			for (String columnname : getOrderedKeys()) {
				sb.append("\"");
				sb.append(columnname);
				sb.append("\" ");
				sb.append(getPropertyTypeMap().get(columnname));
				sb.append(", ");
			}
		}
		String columnDefs = sb.toString();
		if (columnDefs.length() > 2) {
			columnDefs = columnDefs.substring(0, columnDefs.length() - 2);
		}
		return "(" + columnDefs + ")";
	}

}
