package com.xebialabs.xltest.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xltest.repository.ScriptExecutionException;
import com.xebialabs.xltest.repository.ScriptExecutor;
import com.xebialabs.xltest.repository.ScriptExecutorHolder;

import org.slf4j.LoggerFactory;

import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;

import java.io.FileNotFoundException;
import java.io.StringWriter;
import java.security.Permissions;

@Metadata(virtual = true)
public class ScriptedConfigurationItem extends BaseConfigurationItem {

    @Property(description = "location of the script on the class path", required = false)
    private String scriptLocation;

    private transient StringWriter executionLog;

    public void setScriptLocation(String scriptLocation) {
        this.scriptLocation = scriptLocation;
    }

    public String getScriptLocation() {
        return scriptLocation;
    }

    protected <T> T execute(ScriptContext scriptContext) throws ScriptExecutionException, FileNotFoundException {
        executionLog = new StringWriter();
        ResultHolder<T> resultHolder = new ResultHolder();
        scriptContext.setAttribute("resultHolder", resultHolder, ScriptContext.ENGINE_SCOPE);
//        scriptContext.setAttribute("classLoader", this.getClass().getClassLoader(), ScriptContext.ENGINE_SCOPE);

        // TODO: Inject ScriptExecutor via DI
        ScriptExecutor executor = ScriptExecutorHolder.getScriptExecutor();
        if (executor == null) {
            throw new IllegalStateException("Script execution has not been initialized");
        }

        scriptContext.setWriter(executionLog);
        scriptContext.setErrorWriter(executionLog);

        try {
            String scriptPrelude = getScriptPrelude();
            if (scriptPrelude != null) {
                executor.evalScript(scriptPrelude, scriptContext);
            }
            executor.evalScriptedCi(this, scriptContext);
        } finally {
            LoggerFactory.getLogger(getType().toString()).info("Script executed, result: {}", resultHolder.result);
            LoggerFactory.getLogger(getType().toString()).info("Script executed, log: {}", executionLog.toString());
        }

        return resultHolder.result;
    }

    protected ScriptContext getScriptContext() {
        ScriptContext context = new SimpleScriptContext();
        context.setAttribute("self", this, ScriptContext.ENGINE_SCOPE);
        return context;
    }

    protected String getScriptPrelude() {
        return null;
    }

    public String getExecutionLog() {
        return executionLog.toString();
    }

    public static class ResultHolder<T> {
        private T result;

        public void setResult(T result) {
            this.result = result;
        }
        public T getResult() {
            return result;
        }
    }
    
    public static class ProcessHolder<T> {
        private T process;

        public void setProcess(T process) {
            this.process = process;
        }
        public T getProcess() {
            return process;
        }
    }
}
