package com.xebialabs.xltest.domain;

import java.io.Serializable;

public class TestRunId implements Serializable{
    public static final char SEPARATOR = '/';
    public static final TestRunId ROOT = new TestRunId("");

    private final String testRunId;

    public TestRunId(String testRunId) {
        this.testRunId = testRunId;
    }

    public TestRunId(TestRunId parentTestRunId, TestRunId childTestRunId) {
        this(parentTestRunId.toString() + SEPARATOR + childTestRunId.toString());
    }

    public TestRunId getParent() {
        int lastIndex = testRunId.lastIndexOf(SEPARATOR);
        if (lastIndex < 0) {
            return ROOT;
        }
        return new TestRunId(testRunId.substring(0, lastIndex));
    }

    public boolean isRoot() {
        return ROOT.toString().equals(testRunId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TestRunId testRunId1 = (TestRunId) o;

        if (!testRunId.equals(testRunId1.testRunId)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        return testRunId.hashCode();
    }

    @Override
    public String toString() {
        return testRunId;
    }

    public boolean isSameOrChildOf(TestRunId runId) {
        return equals(runId) || (!isRoot() && getParent().isSameOrChildOf(runId));
    }

    public TestRunId getTopLevel() {
        if (getParent().isRoot()) {
            return this;
        }
        return getParent().getTopLevel();
    }
}
