package com.xebialabs.xltest.domain.definitions;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.xltest.domain.TestSetDefinition;

import java.util.Collections;
import java.util.List;
import com.google.common.base.Joiner;

public class FitNesseSubSet extends TestSetDefinition {

    public enum MatchType {
        ANY,
        ALL;
    };
    @Property
    private FitNesse parentSet;

    @Property
    private List<String> tags;

    @Property(defaultValue = "ANY")
    private MatchType match;

    public FitNesse getParentSet() {
        return parentSet;
    }

    public void setParentSet(FitNesse parentSet) {
        this.parentSet = parentSet;
    }

    public List<String> getTags() {
        return tags != null ? tags : Collections.<String>emptyList();
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public MatchType getMatch() {
        return match;
    }

    public void setMatch(MatchType match) {
        this.match = match;
    }

    @Override
    public CmdLine defaultCommandLine() {
        CmdLine cmdLine = new CmdLine().addArgument("./startTestRun.sh")
                .addArgument(getParentSet().getSuiteName());

        if (tags != null && tags.size() > 0) {
            cmdLine.addArgument(getMatch().name())
                    .addArgument(Joiner.on(",").join(getTags()));
        }
        return cmdLine;
    }

}
