package com.xebialabs.xltest.resources;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xltest.domain.ElasticSearchStore;
import com.xebialabs.xltest.domain.EventProcessor;
import com.xebialabs.xltest.domain.LocalTestRun;
import com.xebialabs.xltest.domain.MySQLStore;
import com.xebialabs.xltest.domain.Store;
import com.xebialabs.xltest.domain.TestRunId;
import com.xebialabs.xltest.domain.TestSetDefinition;
import com.xebialabs.xltest.domain.definitions.FitNesse;
import com.xebialabs.xltest.service.EventRegistry;

@Controller
@Path("/initlisteners")
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON)
public class InitializeListenerController {
	private static final String RUN_ID_AS_USED_IN_JMETER = "a7f287f9-bb60-4596-b866-480811d09a49";

	private final static Logger LOG = LoggerFactory.getLogger(InitializeListenerController.class);

    private final RepositoryService repositoryService;
    private final EventRegistry eventRegistry;
    
    // This class is temporalily used (we expect) to get the listeners into the air.
    // Handy when you e.g. do performance testing on stores: you want to send events to the store but without
    // any listener in the air that is impossible....

	@Autowired
	public InitializeListenerController(RepositoryService repositoryService, EventRegistry eventRegistry) {
		this.repositoryService = repositoryService;
		this.eventRegistry = eventRegistry;
	}
	
	@GET
	@Path("/")
	public Response initializeRepoAndDispatcher()  {
		Store store = createESStore();
		// Store store = createMySQLStore(record);
		EventProcessor listener = createListener(store);
		TestSetDefinition testSetDefinition = createTestSetDefinition();
		createTestRun(testSetDefinition);
		
		eventRegistry.registerHandler(new TestRunId(RUN_ID_AS_USED_IN_JMETER), listener);

        return Response.ok().build();
	}
	
	private Store createESStore() {
		Store store = new ElasticSearchStore("http://localhost:9200/xltestperformancetestevents");
		store.setId("Configuration/Stores/store");
		repositoryService.createOrUpdate(store);
		return store;
	}
	
	private Store createMySQLStore() {
		Store store = new MySQLStore("jdbc:mysql://localhost/test", "monty",  "python", "testresults");
		store.setId("Configuration/Stores/store");
		repositoryService.createOrUpdate(store);
		return store;
	}

	private EventProcessor createListener(Store store) {
		List<Store> stores = new ArrayList<Store>();
		stores.add(store);
		EventProcessor listener = new EventProcessor("result", stores);
		listener.setId("Configuration/Listeners/listener");
		repositoryService.createOrUpdate(listener);
		return listener;
	}

	private TestSetDefinition createTestSetDefinition() {
		FitNesse testSetDefinition = new FitNesse();
		testSetDefinition.setSuiteName("ExampleSuite.ComplexSuite");
		testSetDefinition.setId("Configuration/TestSetDefinitions/demo");
		repositoryService.createOrUpdate(testSetDefinition);
		return testSetDefinition;
	}

	private void createTestRun(TestSetDefinition testSetDefinition) {
		LocalTestRun testRun = new LocalTestRun();
		testRun.setTestSetDefinition(testSetDefinition);
		testRun.setId("Applications/TestRuns/" + RUN_ID_AS_USED_IN_JMETER);
		repositoryService.createOrUpdate(testRun);
	}
	
	@DELETE
	@Path("/")
	public Response removeListeners()  {
		TestRunId testRunId = new TestRunId(RUN_ID_AS_USED_IN_JMETER);
		eventRegistry.unregisterAll(testRunId);
		return Response.ok().build();
	}

}

