package com.xebialabs.xltest.resources;

import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;

import static javax.ws.rs.core.Response.Status.NOT_FOUND;

@Path("/")
@Controller
public class StaticResource {

    @GET
    @NoCache
    @Produces("text/html;charset=UTF-8")
    public Response redirectToRoot() throws IOException {
        return getRoot("index.html");
    }

    @GET
    @Path("{path : .*\\.html}")
    @NoCache
    @Produces("text/html;charset=UTF-8")
    public Response getRoot(@PathParam("path") String path) throws IOException {
        return stream(path);
    }

    @GET
    @Path("{path : .*\\.otf}")
    @Produces("font/opentype")
    public Response getOtfFont(@PathParam("path") String path) throws IOException {
        return stream(path);
    }

    @GET
    @Path("{path : .*\\.ico}")
    @Produces("image/vnd.microsoft.icon")
    public Response getIco(@PathParam("path") String path) throws IOException {
        return stream(path);
    }

    @GET
    @Path("{path : .*\\.eot}")
    @Produces("application/vnd.ms-fontobject")
    public Response getEotFont(@PathParam("path") String path) throws IOException {
        return stream(path);
    }

    @GET
    @Path("{path : .*\\.woff}")
    @Produces("application/font-woff")
    public Response getWoffFont(@PathParam("path") String path) throws IOException {
        return stream(path);
    }

    @GET
    @Path("{path : .*\\.ttf}")
    @Produces("application/x-font-ttf")
    public Response getTtfFont(@PathParam("path") String path) throws IOException {
        return stream(path);
    }

    @GET
    @Path("{path : .*\\.svg}")
    @Produces("image/svg+xml")
    public Response getSvg(@PathParam("path") String path) throws IOException {
        return stream(path);
    }

    @GET
    @Path("{path : .*\\.css}")
    @NoCache
    @Produces("text/css")
    public Response getCss(@PathParam("path") String path) throws IOException {
        return stream(path);
    }

    @GET
    @Path("{path : .*\\.png}")
    @Produces("image/png")
    public Response getPng(@PathParam("path") String path) throws IOException {
        return stream(path);
    }

    @GET
    @Path("{path : .*\\.gif}")
    @Produces("image/png")
    public Response getGif(@PathParam("path") String path) throws IOException {
        return stream(path);
    }

    @GET
    @Path("{path : .*\\.js}")
    @Produces("text/javascript")
    public Response getJs(@PathParam("path") String path) throws IOException {
        return stream(path);
    }

    private Response stream(String path) throws IOException {
        InputStream resource = resource(path);

        if (resource == null) {
            return Response.status(NOT_FOUND).build();
        }

        return Response.ok(resource).build();
    }

    /**
     * Returns a handle to a File (relative to the environment.getWebPath() directory) or a Classpath resource.
     */
    private InputStream resource(String path) throws IOException {

        // Serve from classpath
        String realPath = "web/" + path;
        logger.trace("Serving static file: {}", realPath);
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(realPath);
    }

    private static final Logger logger = LoggerFactory.getLogger(StaticResource.class);


}
