/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.xebialabs.xltest.domain.TestRunId;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Event
implements Serializable {
    public static final String START_TEST_RUN = "startTestRun";
    public static final String FINISH_TEST_RUN = "finishTestRun";
    public static final String TYPE = "type";
    public static final String RUN_ID = "run_id";
    public static final String UNKNOWN_EVENT_TYPE = "UNKNOWN";
    public static final String TIMESTAMP = "_ts";
    private static final Logger LOG = LoggerFactory.getLogger(Event.class);
    private final Map<String, Object> properties;

    public Event(Map<String, Object> properties) {
        this.properties = new TreeMap<String, Object>(properties);
        if (!this.properties.containsKey(TIMESTAMP)) {
            this.update(TIMESTAMP, System.currentTimeMillis());
        }
    }

    public Event(String type, Map<String, Object> properties) {
        this(properties);
        this.update(TYPE, type);
    }

    public Event(String type, Event event) {
        this(type, event.getProperties());
    }

    public Event(Event event, Map<String, Object> properties) {
        this(event.getProperties());
        this.properties.putAll(properties);
    }

    public String getType() {
        return (String)this.properties.get(TYPE);
    }

    private Event update(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public <T> T get(String key) {
        Object value = this.properties.get(key);
        if (value == null) {
            LOG.warn(key + " not found in event " + this);
        }
        return (T)value;
    }

    public boolean hasProperty(String key) {
        return this.properties.get(key) != null;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return this.properties.equals(event.properties);
    }

    public int hashCode() {
        int result = this.properties.hashCode();
        return result;
    }

    public String toString() {
        return "Event" + this.properties;
    }

    public static Map<String, Object> props(Object ... keyValues) {
        assert (keyValues.length % 2 == 0);
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        for (int i = 0; i < keyValues.length - 1; i += 2) {
            m.put(keyValues[i].toString(), keyValues[i + 1]);
        }
        return m;
    }

    public TestRunId getTestRunId() {
        Object testRunId = this.get(RUN_ID);
        if (testRunId instanceof TestRunId) {
            return (TestRunId)testRunId;
        }
        return new TestRunId(testRunId.toString());
    }
}

