/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.ScriptedConfigurationItem;
import com.xebialabs.xltest.domain.Store;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.repository.ScriptExecutionException;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(description="Listener base type", root=Metadata.ConfigurationItemRoot.CONFIGURATION)
public class EventProcessor
extends ScriptedConfigurationItem
implements EventHandler {
    @Property(description="Event type this listener listens for, e.g. fitResult")
    private String eventType;
    @Property(description="Stores in which this event needs to be persisted")
    private List<Store> stores;
    private transient Set<Store> usedStores;
    private static final Logger LOG = LoggerFactory.getLogger(EventProcessor.class);

    public EventProcessor() {
    }

    public EventProcessor(String scriptLocation) {
        this.setScriptLocation(scriptLocation);
    }

    public EventProcessor(String eventType, List<Store> stores) {
        this.eventType = eventType;
        this.stores = stores;
    }

    @Override
    public void onReceive(Event event) {
        LOG.info("Received event of type {}", (Object)event.getType());
        if (this.eventTypeMatches(event) && this.getStores() != null) {
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            ArrayList<Store> failingStores = new ArrayList<Store>();
            Event processedEvent = this.process(event);
            for (Store store : this.getStores()) {
                try {
                    LOG.info("Forwarding event of type {}", (Object)(processedEvent.getType() + " to store " + store.getId()));
                    store.store(processedEvent);
                    if (this.usedStores == null) {
                        this.usedStores = new HashSet<Store>();
                    }
                    this.usedStores.add(store);
                }
                catch (Exception e) {
                    exceptions.add(e);
                    failingStores.add(store);
                    e.printStackTrace();
                }
            }
            if (exceptions.size() > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("These stores threw exceptions: ");
                int cnt = 0;
                for (Store store : failingStores) {
                    sb.append(store.getId());
                    sb.append(": ");
                    Exception exception = (Exception)exceptions.get(cnt++);
                    exception.printStackTrace();
                    sb.append(exception.toString());
                    sb.append("; ");
                }
                throw new RuntimeException("Storage exceptions: " + sb.toString());
            }
        }
    }

    public Event process(Event event) {
        ScriptContext context = this.getScriptContext();
        context.setAttribute("event", event, 100);
        Object runId = event.getProperties().get("run_id");
        TestRun testRun = this.getTestRun(runId.toString());
        context.setAttribute("testRun", testRun, 100);
        try {
            return new Event((Map)this.execute(context));
        }
        catch (FileNotFoundException e) {
            LoggerFactory.getLogger((String)this.getType().toString()).info("Could not find script. Deferring to default.");
            return event;
        }
        catch (ScriptExecutionException e) {
            throw new RuntimeException("Could not perform event enrichement.", e);
        }
    }

    private TestRun getTestRun(String runId) {
        return (TestRun)RepositoryServiceHolder.getRepositoryService().read("Applications/TestRuns/" + runId);
    }

    private boolean eventTypeMatches(Event event) {
        return event.getType().matches(this.getEventType());
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public List<Store> getStores() {
        return this.stores;
    }

    public void setStores(List<Store> stores) {
        this.stores = stores;
    }

    public Set<Store> getUsedStores() {
        return this.usedStores;
    }

    public void resetUsedStores() {
        this.usedStores = new HashSet<Store>();
    }
}

