/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.resources;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xltest.domain.EventProcessor;
import com.xebialabs.xltest.domain.Report;
import com.xebialabs.xltest.domain.Store;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.domain.TestSetDefinition;
import java.util.Collection;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/data")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DataController {
    private static final Logger LOG = LoggerFactory.getLogger((String)DataController.class.getName());
    private RepositoryService repository;

    @Autowired
    public DataController(RepositoryService repository) {
        this.repository = repository;
    }

    @GET
    @Path(value="/")
    public Collection<BaseConfigurationItem> getAll(@QueryParam(value="type") String type) {
        SearchParameters query = new SearchParameters();
        if (type != null) {
            query.setType(Type.valueOf((String)type));
        }
        return this.repository.listEntities(query);
    }

    @GET
    @Path(value="/{id:.+}")
    public BaseConfigurationItem get(@PathParam(value="id") String id) {
        LOG.info("reading item with id: " + id);
        return (BaseConfigurationItem)this.repository.read(id);
    }

    @PUT
    @Path(value="/{id:.+}")
    public BaseConfigurationItem update(@PathParam(value="id") String id, BaseConfigurationItem item, @Context HttpServletResponse response) {
        LOG.info("update item with id: " + item.getId());
        if (id.equals(item.getId())) {
            for (PropertyDescriptor propertyDescriptor : item.getType().getDescriptor().getPropertyDescriptors()) {
                String name = propertyDescriptor.getName();
                Object propertyValue = propertyDescriptor.get((ConfigurationItem)item);
                LOG.info("set property " + name + " to value: " + propertyValue);
            }
            this.repository.update((ConfigurationItem[])new BaseConfigurationItem[]{item});
            response.setStatus(201);
        } else {
            response.setStatus(409);
        }
        return item;
    }

    @POST
    @Path(value="/")
    public BaseConfigurationItem create(BaseConfigurationItem item, @Context HttpServletResponse response) {
        this.addPrefixIfNeeded(item);
        LOG.info("create item with id: " + item.getId());
        this.repository.create((ConfigurationItem[])new BaseConfigurationItem[]{item});
        response.setStatus(201);
        return item;
    }

    @DELETE
    @Path(value="/{id:.+}")
    @Consumes(value={"*/*"})
    public void delete(@PathParam(value="id") String id, @Context HttpServletResponse response) {
        LOG.info("delete item with id: " + id);
        this.repository.delete(new String[]{id});
        response.setStatus(200);
    }

    public void addPrefixIfNeeded(BaseConfigurationItem item) {
        String id = item.getId();
        if (id.startsWith("Configuration") || id.startsWith("Applications")) {
            return;
        }
        String rootNodeName = item.getType().getDescriptor().getRoot().getRootNodeName();
        if (rootNodeName == null) {
            throw new RuntimeException("Type " + item.getType() + " is unrooted!");
        }
        String subdir = "";
        if (item.getType().instanceOf(Type.valueOf(Report.class))) {
            subdir = "Reports";
        }
        if (item.getType().instanceOf(Type.valueOf(Store.class))) {
            subdir = "Stores";
        }
        if (item.getType().instanceOf(Type.valueOf(EventProcessor.class))) {
            subdir = "Listeners";
        }
        if (item.getType().instanceOf(Type.valueOf(TestSetDefinition.class))) {
            subdir = "TestSetDefinitions";
        }
        if (item.getType().instanceOf(Type.valueOf(TestRun.class))) {
            subdir = "TestRuns";
        }
        item.setId(rootNodeName + "/" + subdir + "/" + id);
    }
}

