/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.OutputSupplier;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.core.rest.api.SearchParametersFactory;
import com.xebialabs.deployit.core.rest.resteasy.WorkDirTemplate;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.RoleService;
import com.xebialabs.deployit.engine.api.dto.ArtifactAndData;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.replacer.PlaceholderScanner;
import com.xebialabs.deployit.engine.replacer.Placeholders;
import com.xebialabs.deployit.engine.spi.command.CopyCiCommand;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.DeleteCiCommand;
import com.xebialabs.deployit.engine.spi.command.MoveCiCommand;
import com.xebialabs.deployit.engine.spi.command.RenameCiCommand;
import com.xebialabs.deployit.engine.spi.command.RepositoryBaseCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCiCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCisCommand;
import com.xebialabs.deployit.engine.spi.command.util.Update;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import com.xebialabs.deployit.service.replacement.PlaceholderScanningFailedException;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.deployit.util.TFiles;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.ws.rs.QueryParam;
import nl.javadude.t2bus.EventHandlerStrategy;
import nl.javadude.t2bus.event.strategy.ThrowingRuntimeExceptionHandlerStrategy;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RepositoryResource
extends AbstractSecuredResource
implements com.xebialabs.deployit.engine.api.RepositoryService {
    public static final Predicate<String> canRead = new Predicate<String>(){

        public boolean apply(String input) {
            return PlatformPermissions.READ.getPermissionHandler().hasPermission(input);
        }
    };
    public static final Predicate<ConfigurationItemData> hasReadRight = new Predicate<ConfigurationItemData>(){

        public boolean apply(ConfigurationItemData input) {
            return PlatformPermissions.READ.getPermissionHandler().hasPermission(input.getId());
        }
    };
    public static final Predicate<ConfigurationItem> canEdit = new Predicate<ConfigurationItem>(){

        public boolean apply(ConfigurationItem input) {
            return PlatformPermissions.EDIT_REPO.getPermissionHandler().hasPermission(input.getId());
        }
    };
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private Validator validator;
    @Autowired
    private RoleService roleService;
    private static final Logger logger = LoggerFactory.getLogger(RepositoryResource.class);

    public ConfigurationItem read(String id) {
        this.checkPermission(PlatformPermissions.READ, id);
        return this.repositoryService.read(id, 1);
    }

    public List<ConfigurationItem> read(List<String> ids) {
        ArrayList result = Lists.newArrayList();
        Collection datas = Collections2.filter(ids, canRead);
        for (String data : datas) {
            try {
                ConfigurationItem entity = this.repositoryService.read(data, 1);
                result.add(entity);
            }
            catch (RuntimeException re) {
                logger.error("Could not read configuration item [{}]", (Object)data);
                logger.error("Exception was: ", (Throwable)re);
            }
        }
        return result;
    }

    public List<ConfigurationItemId> query(Type type, String parent, String ancestor, String namePattern, DateTime lastModifiedBefore, DateTime lastModifiedAfter, long page, long resultPerPage) {
        return this.list(SearchParametersFactory.createSearchParams(type, page, resultPerPage, parent, ancestor, namePattern, lastModifiedBefore != null ? lastModifiedBefore.toGregorianCalendar() : null, 0));
    }

    public List<ConfigurationItemId> candidateValues(@QueryParam(value="propertyName") String propertyName, @QueryParam(value="namePattern") String namePattern, @QueryParam(value="page") long page, @QueryParam(value="resultsPerPage") long resultPerPage, ConfigurationItem ci) {
        return this.list(SearchParametersFactory.createSearchParamsForCandidateValues(propertyName, namePattern, page, resultPerPage, ci));
    }

    private List<ConfigurationItemId> list(SearchParameters searchParams) {
        FluentIterable filtered = FluentIterable.from((Iterable)this.repositoryService.list(searchParams)).filter(hasReadRight).transform(DtoReader.ciDataToCiId);
        return Lists.newArrayList((Iterable)filtered);
    }

    public ConfigurationItem create(String id, ConfigurationItem ci) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        Checks.checkArgument((boolean)id.equals(ci.getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{ci.getId(), id});
        return this.createInternal(ci);
    }

    @Workdir
    public ConfigurationItem create(final String id, final ArtifactAndData aad) {
        return WorkDirTemplate.cleanOnFinally(new WorkDirTemplate.Callback<ConfigurationItem>(){

            @Override
            public ConfigurationItem doWithWorkdir(WorkDir workDir) {
                RepositoryResource.this.checkPermission(PlatformPermissions.EDIT_REPO, id);
                Artifact artifact = aad.getArtifact();
                Checks.checkArgument((boolean)id.equals(artifact.getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{artifact.getId(), id});
                artifact.setFile((OverthereFile)RepositoryResource.readArtifactData(aad, workDir));
                if (artifact instanceof FolderArtifact) {
                    Checks.checkTrue((boolean)TFiles.isArchive((String)artifact.getFile().getPath()), (String)"Folder artifact [%s] is not a valid ZIP archive", (Object[])new Object[]{artifact.getFile().getName()});
                }
                if (artifact instanceof SourceArtifact) {
                    try {
                        Placeholders.scanPlaceholders((SourceArtifact)((SourceArtifact)artifact), (PlaceholderScanner)new MustachePlaceholderScanner());
                    }
                    catch (RuntimeException re) {
                        PlaceholderScanningFailedException.throwException((String)artifact.getId(), (RuntimeException)re);
                    }
                }
                return RepositoryResource.this.createInternal((ConfigurationItem)artifact);
            }
        });
    }

    private ConfigurationItem createInternal(ConfigurationItem ci) {
        this.validator.validateCi(ci);
        this.publishCommand((RepositoryBaseCommand)RepositoryResource.createCommandWithNestedCis(Collections.singletonList(ci)));
        return this.repositoryService.read(ci.getId(), 1);
    }

    public List<ConfigurationItem> create(List<ConfigurationItem> cis) {
        List ciIds = Lists.transform(cis, (Function)new Function<ConfigurationItem, String>(){

            public String apply(ConfigurationItem from) {
                return from.getId();
            }
        });
        for (String s : ciIds) {
            this.checkPermission(PlatformPermissions.EDIT_REPO, s);
        }
        this.validator.validateCis(cis);
        CreateCisCommand event = RepositoryResource.createCommandWithNestedCis(cis);
        this.publishCommand((RepositoryBaseCommand)event);
        return this.reloadEntityAndCreateSuccessResponse(cis);
    }

    public ConfigurationItem update(String id, ConfigurationItem ci) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        Checks.checkArgument((boolean)id.equals(ci.getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{ci.getId(), id});
        return this.updateInternal(ci);
    }

    @Workdir
    public ConfigurationItem update(final String id, final ArtifactAndData aad) {
        return WorkDirTemplate.cleanOnFinally(new WorkDirTemplate.Callback<ConfigurationItem>(){

            @Override
            public ConfigurationItem doWithWorkdir(WorkDir workDir) {
                RepositoryResource.this.checkPermission(PlatformPermissions.EDIT_REPO, id);
                Checks.checkArgument((boolean)id.equals(aad.getArtifact().getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{aad.getArtifact().getId(), id});
                aad.getArtifact().setFile((OverthereFile)RepositoryResource.readArtifactData(aad, workDir));
                return RepositoryResource.this.updateInternal((ConfigurationItem)aad.getArtifact());
            }
        });
    }

    public List<ConfigurationItem> update(List<ConfigurationItem> cis) {
        Collection filter = Collections2.filter(cis, canEdit);
        ArrayList updates = Lists.newArrayList();
        for (ConfigurationItem configurationItem : filter) {
            if (this.repositoryService.exists(configurationItem.getId())) {
                ConfigurationItem previous = this.repositoryService.read(configurationItem.getId(), 1, null, false);
                updates.add(new Update(previous, configurationItem));
                continue;
            }
            updates.add(new Update(null, configurationItem));
        }
        UpdateCisCommand command = new UpdateCisCommand((List)updates);
        this.publishCommand((RepositoryBaseCommand)command);
        return this.reloadEntityAndCreateSuccessResponse(filter);
    }

    public ConfigurationItem move(String id, String targetId) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        Splitter splitter = Splitter.on((String)"/");
        Checks.checkArgument((boolean)this.getFirst(splitter.split((CharSequence)id)).equals(this.getFirst(splitter.split((CharSequence)targetId))), (String)"Cannot move ci [%s] to [%s] because that is outside of the root where it is stored.", (Object[])new Object[]{id, targetId});
        this.publishCommand((RepositoryBaseCommand)new MoveCiCommand(id, targetId));
        return this.read(targetId);
    }

    public ConfigurationItem copy(String id, String targetId) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        Splitter splitter = Splitter.on((String)"/");
        Checks.checkArgument((boolean)this.getFirst(splitter.split((CharSequence)id)).equals(this.getFirst(splitter.split((CharSequence)targetId))), (String)"Cannot move ci [%s] to [%s] because that is outside of the root where it is stored.", (Object[])new Object[]{id, targetId});
        this.publishCommand((RepositoryBaseCommand)new CopyCiCommand(id, targetId, this.read(id).getType()));
        return this.read(targetId);
    }

    private String getFirst(Iterable<String> iterable) {
        return iterable.iterator().next();
    }

    public ConfigurationItem rename(String id, String targetName) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        this.publishCommand((RepositoryBaseCommand)new RenameCiCommand(id, targetName, this.read(id).getType()));
        String targetId = id.substring(0, id.lastIndexOf(47) + 1) + targetName;
        return this.read(targetId);
    }

    public List<ConfigurationItem> validate(List<ConfigurationItem> cis) {
        this.validator.validateCis(cis);
        return cis;
    }

    public void delete(String id) {
        this.checkDeletePermission(id);
        this.publishCommand((RepositoryBaseCommand)new DeleteCiCommand(id));
    }

    protected void checkDeletePermission(String id) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
    }

    public Boolean exists(String id) {
        return this.repositoryService.exists(id);
    }

    private ConfigurationItem updateInternal(ConfigurationItem ci) {
        this.validator.validateCi(ci);
        ConfigurationItem previous = this.repositoryService.read(ci.getId(), false);
        this.publishCommand((RepositoryBaseCommand)new UpdateCiCommand(previous, ci));
        return this.repositoryService.read(ci.getId(), 1);
    }

    static CreateCisCommand createCommandWithNestedCis(List<ConfigurationItem> cis) {
        Set<ConfigurationItem> ciSet = RepositoryResource.collectNestedCis(cis, Sets.newHashSet());
        return new CreateCisCommand((List)Lists.newArrayList(ciSet));
    }

    private List<ConfigurationItem> reloadEntityAndCreateSuccessResponse(Collection<ConfigurationItem> cis) {
        ArrayList reloaded = Lists.newArrayList();
        for (ConfigurationItem ci : cis) {
            ConfigurationItem reloadedCi = this.repositoryService.read(ci.getId(), 1);
            reloaded.add(reloadedCi);
        }
        return reloaded;
    }

    static Set<ConfigurationItem> collectNestedCis(Collection<? extends ConfigurationItem> cis, Set<ConfigurationItem> listWithNested) {
        for (ConfigurationItem configurationItem : cis) {
            listWithNested.add(configurationItem);
            for (PropertyDescriptor property : configurationItem.getType().getDescriptor().getPropertyDescriptors()) {
                PropertyKind kind = property.getKind();
                if (kind != PropertyKind.SET_OF_CI && kind != PropertyKind.LIST_OF_CI) continue;
                Collection<ConfigurationItem> children = RepositoryResource.getChildren(configurationItem, property);
                RepositoryResource.collectNestedCis(children, listWithNested);
            }
        }
        return listWithNested;
    }

    static Collection<ConfigurationItem> getChildren(ConfigurationItem parent, PropertyDescriptor property) {
        Collection references = (Collection)property.get(parent);
        if (property.isAsContainment()) {
            return references;
        }
        ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
        for (ConfigurationItem ci : references) {
            if (!RepositoryResource.isChild(ci, parent)) continue;
            children.add(ci);
        }
        return children;
    }

    private static LocalFile readArtifactData(ArtifactAndData aad, WorkDir workDir) {
        Checks.checkArgument((aad.getFilename() != null ? 1 : 0) != 0, (String)"The filename for the artifact should not be null", (Object[])new Object[0]);
        final LocalFile localFile = workDir.newFile(aad.getFilename());
        try {
            ByteStreams.write((byte[])aad.getData(), (OutputSupplier)new OutputSupplier<OutputStream>(){

                public OutputStream getOutput() throws IOException {
                    return localFile.getOutputStream();
                }
            });
        }
        catch (IOException e) {
            throw new DeployitException("Could not write Artifact data for [" + aad.getArtifact().getId() + "] to [" + localFile + "]");
        }
        return localFile;
    }

    private static boolean isChild(ConfigurationItem ci, ConfigurationItem parent) {
        for (PropertyDescriptor property : ci.getType().getDescriptor().getPropertyDescriptors()) {
            PropertyKind kind = property.getKind();
            if (kind != PropertyKind.CI || !parent.equals(property.get(ci))) continue;
            return true;
        }
        return false;
    }

    private void publishCommand(RepositoryBaseCommand event) {
        List roles = this.roleService.listMyRoles();
        event.setSecurityContext(Permissions.getAuthenticatedUserName(), roles);
        EventBusHolder.publish((Object)event, (EventHandlerStrategy)new ThrowingRuntimeExceptionHandlerStrategy());
    }
}

