/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.xebialabs.xltest.domain.Report;
import com.xebialabs.xltest.domain.TestRun;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerReport
extends Report {
    private static Logger LOG = LoggerFactory.getLogger(FreemarkerReport.class);

    @Override
    public String compute(TestRun testRun) {
        String format;
        try {
            format = this.readTemplateFile(this.getScriptLocation());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not perform freemarker report transformation.", e);
        }
        HashMap<String, Object> templateProperties = new HashMap<String, Object>(this.getAttributes());
        templateProperties.put("testRun", testRun);
        return this.format(templateProperties, format);
    }

    private String readTemplateFile(String fileName) throws IOException {
        String line;
        InputStream is = this.getClass().getResourceAsStream("/" + fileName);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    private String format(Map<String, Object> properties, String format) {
        try {
            Template t = new Template(this.getScriptLocation(), (Reader)new StringReader(format), new Configuration());
            StringWriter sw = new StringWriter();
            t.process(properties, (Writer)sw);
            return sw.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
        catch (TemplateException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }
}

