/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xltest.domain.Computable;
import com.xebialabs.xltest.domain.ScriptedConfigurationItem;
import com.xebialabs.xltest.domain.TestRun;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.script.ScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Metadata(description="Report base type", root=Metadata.ConfigurationItemRoot.CONFIGURATION, virtual=true)
public class Report
extends ScriptedConfigurationItem
implements Computable<TestRun, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(Report.class);
    @Property(description="List of TestSetDefinitions which the reporting tool can handle on the given url", required=false)
    private List<String> testSetTypes;
    @Property(description="The type of report. One of 'link', 'highchart', 'table', 'html', 'qualification'")
    private String reportType;
    @Autowired
    private transient RepositoryService repository;
    private Map<String, Object> attributes = new TreeMap<String, Object>();

    public List<String> getTestSetTypes() {
        return this.testSetTypes;
    }

    public void setTestSetTypes(List<String> testSetTypes) {
        this.testSetTypes = testSetTypes;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    @Override
    public Object compute(TestRun testRun) {
        ScriptContext context = this.getScriptContext();
        for (String key : this.attributes.keySet()) {
            context.setAttribute(key, this.attributes.get(key), 100);
        }
        context.setAttribute("testRun", testRun, 100);
        context.setAttribute("repository", this.repository, 100);
        try {
            LOG.debug("About to generate report");
            Object result = this.execute(context);
            if (this.thisIsAQualification(testRun)) {
                this.storeQualificationResultInRun(result, testRun);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not perform report transformation.", e);
        }
    }

    private void storeQualificationResultInRun(Object result, TestRun testRun) {
        if (result instanceof Boolean) {
            testRun.setQualificationResult((Boolean)result);
            this.repository.update((ConfigurationItem[])new TestRun[]{testRun});
        } else {
            LOG.warn("Qualification result is not a Boolean. I got: {}", result);
        }
    }

    private boolean thisIsAQualification(TestRun testRun) {
        return testRun.getTestSetDefinition().getQualification() != null && this.getId().equals(testRun.getTestSetDefinition().getQualification().getId());
    }

    public void addAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    protected Map<String, Object> getAttributes() {
        return this.attributes;
    }

    protected RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }
}

