/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.BlockBuilder;
import com.xebialabs.deployit.engine.tasker.BlockBuilders;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.EventProcessor;
import com.xebialabs.xltest.domain.Planable;
import com.xebialabs.xltest.domain.ScriptedConfigurationItem;
import com.xebialabs.xltest.domain.Store;
import com.xebialabs.xltest.domain.TestRunId;
import com.xebialabs.xltest.domain.TestSetDefinition;
import com.xebialabs.xltest.plan.LeadTimePlan;
import com.xebialabs.xltest.plan.ParallelPlan;
import com.xebialabs.xltest.plan.Plan;
import com.xebialabs.xltest.plan.SerialPlan;
import com.xebialabs.xltest.plan.TestPlan;
import com.xebialabs.xltest.repository.ScriptExecutionException;
import com.xebialabs.xltest.service.EventDispatcher;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Metadata(description="Test run base type", root=Metadata.ConfigurationItemRoot.APPLICATIONS, virtual=true)
public class TestRun
extends ScriptedConfigurationItem
implements Planable<Block> {
    private static final Logger LOG = LoggerFactory.getLogger(TestRun.class);
    public static final String TEST_SET_ID = "testSetId";
    public static final String TEST_RUN = "testRun";
    public static final String EVENT_URI = "eventUri";
    public static final String ID = "run_id";
    @Autowired
    private transient EventDispatcher eventDispatcher;
    @Property(label="Test set name", description="test set")
    private TestSetDefinition testSetDefinition;
    @Property(description="callback URI", required=false)
    private String uri;
    @Property(description="Start time of the test run", required=false)
    private Date startTime;
    @Property(description="Time the test run finished", required=false)
    private Date finishedTime;
    @Property(description="Stores in which events were persisted during this test run", required=false)
    private Set<Store> usedStores;
    @Property(description="Final qualificationResult", required=false)
    private boolean qualificationResult;

    public TestRunId getTestRunId() {
        String id = this.getId();
        if (this.getId().startsWith("Applications/TestRuns/")) {
            id = id.substring("Applications/TestRuns/".length());
        }
        return new TestRunId(id);
    }

    public TestSetDefinition getTestSetDefinition() {
        return this.testSetDefinition;
    }

    public void setTestSetDefinition(TestSetDefinition testSetDefinition) {
        this.testSetDefinition = testSetDefinition;
    }

    public URI getUri() {
        return UriBuilder.fromUri((String)this.uri).build(new Object[0]);
    }

    public void setUri(URI uri) {
        this.uri = uri.toString();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getFinishedTime() {
        return this.finishedTime;
    }

    public void setFinishedTime(Date finishedTime) {
        this.finishedTime = finishedTime;
    }

    public boolean isFinished() {
        return this.finishedTime != null;
    }

    public Set<Store> getUsedStores() {
        return this.usedStores != null ? this.usedStores : Collections.emptySet();
    }

    public boolean getQualificationResult() {
        return this.qualificationResult;
    }

    public void setQualificationResult(boolean qualificationResult) {
        this.qualificationResult = qualificationResult;
    }

    public List<Event> getEvents(Map queryParameters, final String sortingProperty) {
        List<Event> events = this.getEvents(queryParameters);
        ArrayList filteredEvents = Lists.newArrayList((Iterable)Iterables.filter(events, (Predicate)new Predicate<Event>(){

            public boolean apply(@Nullable Event e) {
                return e.hasProperty(sortingProperty) && e.get(sortingProperty) instanceof Comparable;
            }
        }));
        Collections.sort(filteredEvents, new Comparator<Event>(){

            @Override
            public int compare(Event o1, Event o2) {
                String s1 = (String)o1.get(sortingProperty);
                String s2 = (String)o2.get(sortingProperty);
                return s1.compareTo(s2);
            }
        });
        return filteredEvents;
    }

    public List<Event> getEvents(Map queryParameters) {
        ArrayList<Event> events = new ArrayList<Event>();
        for (Store s : this.getUsedStores()) {
            events.addAll(s.getEventsOfRun(this.getTestRunId(), queryParameters));
        }
        return events;
    }

    public List<Event> getEvents() {
        ArrayList<Event> events = new ArrayList<Event>();
        for (Store s : this.getUsedStores()) {
            events.addAll(s.getEventsOfRun(this.getTestRunId()));
        }
        return events;
    }

    public List<Event> getEventsBetween(long startTime, long endTime, Map queryParameters) {
        ArrayList<Event> events = new ArrayList<Event>();
        for (Store s : this.getUsedStores()) {
            events.addAll(s.getEventsBetween(startTime, endTime, queryParameters));
        }
        return events;
    }

    public Map<String, List<Event>> getEventsFromRunsAsMapGroupedBy(String mapProperty, List<TestRun> runs, String ... matchingKVs) {
        Map<String, Object> properties = this.makeEventProperties(matchingKVs);
        Set<String> keySet = properties.keySet();
        String[] matchingProperties = keySet.toArray(new String[keySet.size()]);
        Event event = new Event(properties);
        List<Event> allEvents = this.getCorrespondingEventsFromOtherRuns(event, runs, matchingProperties);
        HashMap<String, List<Event>> map = new HashMap<String, List<Event>>();
        for (Event e : allEvents) {
            String groupByValue = (String)e.get(mapProperty);
            if (map.get(groupByValue) == null) {
                map.put(groupByValue, new ArrayList());
            }
            ((List)map.get(groupByValue)).add(e);
        }
        for (String key : map.keySet()) {
            Collections.sort((List)map.get(key), new Comparator<Event>(){

                @Override
                public int compare(Event r1, Event r2) {
                    Long ts1 = (Long)r1.get("_ts");
                    Long ts2 = (Long)r2.get("_ts");
                    return ts2.compareTo(ts1);
                }
            });
        }
        return map;
    }

    private Map<String, Object> makeEventProperties(String[] matchingKVs) {
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        for (int i = 0; i < matchingKVs.length; ++i) {
            Pair p = this.parseKV(matchingKVs[i]);
            eventProperties.put(p.getKey(), p.getValue());
        }
        return eventProperties;
    }

    private Pair parseKV(String kv) {
        String key = kv.substring(0, kv.indexOf(58));
        String value = kv.substring(key.length() + 1);
        return new Pair(key, value);
    }

    public List<Event> getCorrespondingEventsFromOtherRuns(Event event, List<TestRun> otherRuns, String ... matchingProperties) {
        ArrayList<Event> events = new ArrayList<Event>();
        Map queryParameters = this.makeQueryParameters(event, matchingProperties);
        for (TestRun previousRun : otherRuns) {
            List<Event> eventsOfPreviousRun = previousRun.getEvents(queryParameters);
            LOG.debug("Found " + eventsOfPreviousRun.size() + " events with matching properties in a previous run");
            events.addAll(eventsOfPreviousRun);
        }
        LOG.debug("Found " + events.size() + " CorrespondingEventsFromOlderRuns. They are:");
        for (Event e : events) {
            LOG.debug("    " + e.toString());
        }
        return events;
    }

    public List<Event> getCorrespondingEventsFromOlderRuns(Event event, int max, String ... matchingProperties) {
        ArrayList<Event> events = new ArrayList<Event>();
        List<TestRun> previousRuns = this.getPreviousRuns(max);
        LOG.debug("While getting events from max " + max + " previous Runs, I got " + previousRuns.size() + " such runs");
        Map queryParameters = this.makeQueryParameters(event, matchingProperties);
        for (TestRun previousRun : previousRuns) {
            List<Event> eventsOfPreviousRun = previousRun.getEvents(queryParameters);
            LOG.debug("Found " + eventsOfPreviousRun.size() + " events with matching properties in a previous run");
            events.addAll(eventsOfPreviousRun);
        }
        LOG.debug("Found " + events.size() + " CorrespondingEventsFromOlderRuns. They are:");
        for (Event e : events) {
            LOG.debug("    " + e.toString());
        }
        return events;
    }

    private Map makeQueryParameters(Event event, String ... matchingProperties) {
        HashMap queryParameters = new HashMap();
        if (matchingProperties != null && matchingProperties.length != 0) {
            for (int i = 0; i < matchingProperties.length; ++i) {
                String propertyKey = matchingProperties[i];
                queryParameters.put(propertyKey, event.get(propertyKey));
            }
        }
        return queryParameters;
    }

    public List<TestRun> getPreviousRunsIncludingThisOne(int max) {
        List<TestRun> runs = this.getPreviousRuns(max);
        runs.add(this);
        return runs;
    }

    public List<TestRun> getPreviousRuns(int max) {
        RepositoryService repositoryService = RepositoryServiceHolder.getRepositoryService();
        SearchParameters query = new SearchParameters().setType(Type.valueOf(TestRun.class));
        List allTestRuns = repositoryService.listEntities(query);
        String testSetDefinitionId = this.getTestSetDefinition().getId();
        ArrayList<TestRun> allTestRunsWithTheSameTestSetDefinition = new ArrayList<TestRun>();
        for (TestRun testRun : allTestRuns) {
            if (!testRun.getTestSetDefinition().getId().equals(testSetDefinitionId)) continue;
            allTestRunsWithTheSameTestSetDefinition.add(testRun);
        }
        Collections.sort(allTestRunsWithTheSameTestSetDefinition, new Comparator<TestRun>(){

            @Override
            public int compare(TestRun r1, TestRun r2) {
                return r2.getStartTime().compareTo(r1.getStartTime());
            }
        });
        ArrayList<TestRun> previousTestRuns = new ArrayList<TestRun>();
        Date startTime = this.getStartTime();
        int cnt = 0;
        for (TestRun testRun : allTestRunsWithTheSameTestSetDefinition) {
            if (testRun.getStartTime().before(startTime)) {
                previousTestRuns.add(testRun);
                ++cnt;
            }
            if (cnt < max) continue;
            break;
        }
        LOG.debug("I got " + previousTestRuns.size() + " previous runs");
        return previousTestRuns;
    }

    public Set<Store> setUsedStores(Set<Store> stores) {
        this.usedStores = stores;
        return this.usedStores;
    }

    public void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public Block plan() {
        Plan plan = this.getTestSetDefinition().plan();
        return BlockBuilders.serial((String)("Test run " + this.getId()), (List)Lists.newArrayList((Object[])new BlockBuilder[]{BlockBuilders.steps((String)"Initialize listeners", this.taskStep(new InitializeListenersStep())), BlockBuilders.steps((String)"Start test run", this.taskStep(new EventEmittingStep(this.newStartTestRunEvent()))), this.blockBuilder(plan), BlockBuilders.steps((String)"Finish test run", this.taskStep(new EventEmittingStep(this.newFinishTestRunEvent()))), BlockBuilders.steps((String)"Unload listeners", this.taskStep(new RemoveListenersStep()))})).build();
    }

    public BlockBuilder planWithoutBuilding() {
        Plan plan = this.getTestSetDefinition().plan();
        return BlockBuilders.serial((String)("Test run " + this.getId()), (List)Lists.newArrayList((Object[])new BlockBuilder[]{BlockBuilders.steps((String)"Initialize listeners", this.taskStep(new InitializeListenersStep())), BlockBuilders.steps((String)"Start test run", this.taskStep(new EventEmittingStep(this.newStartTestRunEvent()))), this.blockBuilder(plan), BlockBuilders.steps((String)"Finish test run", this.taskStep(new EventEmittingStep(this.newFinishTestRunEvent()))), BlockBuilders.steps((String)"Unload listeners", this.taskStep(new RemoveListenersStep()))}));
    }

    private BlockBuilder blockBuilder(Plan plan) {
        if (plan instanceof TestPlan) {
            LOG.info("Plan is an instance of TestPlan, its class: " + plan.getClass().getName());
            TestSetDefinition testSet = ((TestPlan)plan).getTestSet();
            return this.testStep((TestPlan)plan);
        }
        if (plan instanceof ParallelPlan) {
            LOG.info("Plan is an instance of ParallelPlan, its class: " + plan.getClass().getName());
            return BlockBuilders.parallel((String)"In parallel", this.blockBuilders(((ParallelPlan)plan).getPlans()));
        }
        if (plan instanceof SerialPlan) {
            LOG.info("Plan is an instance of SerialPlan, its class: " + plan.getClass().getName());
            return BlockBuilders.serial((String)"In sequence", this.blockBuilders(((SerialPlan)plan).getPlans()));
        }
        if (plan instanceof LeadTimePlan) {
            LeadTimePlan leadTimePlan = (LeadTimePlan)plan;
            return this.getLeadTimeBlockBuilder(leadTimePlan.getLeadTime());
        }
        throw new RuntimeException("Unknown plan type: " + plan);
    }

    protected List<StepState> taskStep(Step step) {
        return Lists.newArrayList((Object[])new StepState[]{new TaskStep(step)});
    }

    private List<BlockBuilder> blockBuilders(List<Plan> plans) {
        LinkedList<BlockBuilder> blockList = new LinkedList<BlockBuilder>();
        for (Plan plan : plans) {
            blockList.add(this.blockBuilder(plan));
        }
        return blockList;
    }

    protected BlockBuilder testStep(TestPlan testPlan) {
        return BlockBuilders.steps((String)String.format("Test run for %s", this.getTestSetDefinition().getId()), this.getSteps(testPlan));
    }

    protected BlockBuilder getLeadTimeBlockBuilder(int secs) {
        return BlockBuilders.steps((String)String.format("Wait for other processes to start...", new Object[0]), this.getWaitStep(secs));
    }

    protected List<StepState> getSteps(TestPlan testPlan) {
        return Lists.newArrayList((Object[])new StepState[]{new TaskStep((Step)new ScriptExecutionStep(testPlan))});
    }

    protected List<StepState> getWaitStep(int secs) {
        return Lists.newArrayList((Object[])new StepState[]{new TaskStep((Step)new WaitStep(secs))});
    }

    protected Map<String, Object> newStartTestRunEvent() {
        return Event.props("type", "startTestRun", ID, this.getTestRunId().toString(), TEST_SET_ID, this.getTestSetDefinition().getId(), EVENT_URI, this.getUri().toString());
    }

    protected Map<String, Object> newFinishTestRunEvent() {
        return Event.props("type", "finishTestRun", ID, this.getTestRunId().toString(), TEST_SET_ID, this.getTestSetDefinition().getId());
    }

    public class Pair {
        private String key;
        private Object value;

        public Pair(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    public class ScriptExecutionStep
    implements Step {
        private TestPlan testPlan;

        public ScriptExecutionStep(TestPlan testPlan) {
            this.testPlan = testPlan;
        }

        public int getOrder() {
            return 0;
        }

        public String getDescription() {
            return String.format("Executing Test set '%s' on local environment", TestRun.this.getTestSetDefinition().getId());
        }

        public StepExitCode execute(ExecutionContext executionContext) throws Exception {
            ScriptContext context = TestRun.this.getScriptContext();
            context.setAttribute("testSet", this.testPlan.getTestSet(), 100);
            context.setAttribute("commandLine", this.testPlan.getCommandLine(), 100);
            context.setAttribute("repository", executionContext.getRepository(), 100);
            context.setAttribute("eventDispatcher", TestRun.this.eventDispatcher, 100);
            try {
                Object exitCode = TestRun.this.execute(context);
                if (exitCode == null || exitCode instanceof Number && ((Number)exitCode).intValue() == 0) {
                    return StepExitCode.SUCCESS;
                }
            }
            catch (FileNotFoundException e) {
                LOG.error("Could not find script.");
            }
            catch (ScriptExecutionException e) {
                LOG.error("Could not perform script.", (Throwable)e);
            }
            catch (Throwable t) {
                LOG.error("Could not perform script.", t);
            }
            return StepExitCode.FAIL;
        }
    }

    protected class WaitStep
    implements Step {
        private int secs = 0;

        public WaitStep(int secs) {
            this.secs = secs;
        }

        public int getOrder() {
            return 0;
        }

        public String getDescription() {
            return "Wait for " + this.secs + " seconds to allow parallel processes to start up";
        }

        public StepExitCode execute(ExecutionContext ctx) throws Exception {
            Thread.sleep(1000 * this.secs);
            return StepExitCode.SUCCESS;
        }
    }

    protected class RemoveListenersStep
    implements Step {
        protected RemoveListenersStep() {
        }

        public StepExitCode execute(ExecutionContext executionContext) throws Exception {
            this.collectUsedStoresAndPersistWithTestRun(executionContext);
            TestRun.this.eventDispatcher.unregisterAll(TestRun.this.getTestRunId());
            return StepExitCode.SUCCESS;
        }

        private void collectUsedStoresAndPersistWithTestRun(ExecutionContext executionContext) {
            List<EventHandler> runSpecificEventHandlers = TestRun.this.eventDispatcher.getRunSpecificEventHandlers(TestRun.this.getTestRunId());
            for (EventHandler eh : runSpecificEventHandlers) {
                Set<Store> usedStoresInListener;
                if (!(eh instanceof EventProcessor) || (usedStoresInListener = ((EventProcessor)eh).getUsedStores()) == null) continue;
                TestRun.this.usedStores.addAll(usedStoresInListener);
            }
            LOG.info("Found stores for this Test run: " + TestRun.this.usedStores);
        }

        public String getDescription() {
            return "Deregister event listeners";
        }

        public int getOrder() {
            return 0;
        }
    }

    protected class InitializeListenersStep
    implements Step {
        protected InitializeListenersStep() {
        }

        public StepExitCode execute(ExecutionContext executionContext) throws Exception {
            if (executionContext.getRepository() == null) {
                LOG.error("Repository not set on ExecutionContext. Can not initialize Event processors");
                return StepExitCode.FAIL;
            }
            TestRunId testRunId = TestRun.this.getTestRunId();
            Type type = Type.valueOf(EventProcessor.class);
            List listeners = executionContext.getRepository().search(type);
            if (listeners != null) {
                LOG.info("I am registering " + listeners.size() + " event processors as handler in eventDispatcher for run " + testRunId.toString());
                for (EventProcessor l : listeners) {
                    l.resetUsedStores();
                    TestRun.this.eventDispatcher.registerHandler(testRunId, l);
                }
            }
            return StepExitCode.SUCCESS;
        }

        public String getDescription() {
            return "Initialize event listeners";
        }

        public int getOrder() {
            return 0;
        }
    }

    protected class EventEmittingStep
    implements Step {
        private final Map<String, Object> properties;

        public EventEmittingStep(Map<String, Object> properties) {
            this.properties = properties;
        }

        public int getOrder() {
            return 0;
        }

        public String getDescription() {
            return String.format("Send '%s' event", this.properties.get("type"));
        }

        public StepExitCode execute(ExecutionContext executionContext) throws Exception {
            TestRun.this.eventDispatcher.notify(TestRun.this.getTestRunId(), new Event(this.properties));
            return StepExitCode.SUCCESS;
        }
    }
}

