/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.xltest.domain.Planable;
import com.xebialabs.xltest.domain.Report;
import com.xebialabs.xltest.domain.ScriptedConfigurationItem;
import com.xebialabs.xltest.plan.Plan;
import com.xebialabs.xltest.plan.TestPlan;
import com.xebialabs.xltest.repository.ScriptExecutionException;
import java.io.FileNotFoundException;
import org.slf4j.LoggerFactory;

@Metadata(description="A Test set definition", root=Metadata.ConfigurationItemRoot.CONFIGURATION, virtual=true)
public class TestSetDefinition
extends ScriptedConfigurationItem
implements Planable<Plan> {
    @Property(description="The report used to determine the outcome of a test run (success/fail)", required=false)
    private Report qualification;
    @Property(description="The maximum number of minutes this test may execute", required=false)
    private int timeout;
    @Property(description="When the test run times out, run this command to e.g. clean up", required=false)
    private String cleanupCommandUponTimeout;

    public static <T extends TestSetDefinition> T create(String id, Type type) {
        Descriptor reporterDescriptor = DescriptorRegistry.getDescriptor((Type)type);
        return (T)((TestSetDefinition)reporterDescriptor.newInstance(id));
    }

    @Override
    public Plan plan() {
        try {
            return (Plan)this.execute(this.getScriptContext());
        }
        catch (FileNotFoundException e) {
            LoggerFactory.getLogger((String)this.getType().toString()).info("Could not find plan script. Deferring to default.");
            return new TestPlan(this, this.defaultCommandLine());
        }
        catch (ScriptExecutionException e) {
            throw new RuntimeException("Could not create plan.", e);
        }
    }

    public CmdLine defaultCommandLine() {
        return new CmdLine().addArgument(this.getType().getName());
    }

    public void setQualification(Report qualification) {
        this.qualification = qualification;
    }

    public Report getQualification() {
        return this.qualification;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getCleanupCommandUponTimeout() {
        return this.cleanupCommandUponTimeout;
    }

    public void setCleanupCommandUponTimeout(String cleanupCommandUponTimeout) {
        this.cleanupCommandUponTimeout = cleanupCommandUponTimeout;
    }
}

