/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain.definitions;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xltest.domain.TestSetDefinition;
import com.xebialabs.xltest.plan.LeadTimePlan;
import com.xebialabs.xltest.plan.ParallelPlan;
import com.xebialabs.xltest.plan.Plan;
import com.xebialabs.xltest.plan.SerialPlan;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.python.google.common.collect.Lists;

public class SuperSet
extends TestSetDefinition {
    @Property
    private List<TestSetDefinition> sets = Collections.emptyList();
    @Property(defaultValue="false")
    private boolean parallel;
    @Property
    private int leadTime;

    public List<TestSetDefinition> getSets() {
        return this.sets;
    }

    public void setSets(List<TestSetDefinition> sets) {
        this.sets = sets;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    @Override
    public Plan plan() {
        LinkedList<Plan> plans = new LinkedList<Plan>();
        int leadTimeInsec = 0;
        for (TestSetDefinition set : this.sets) {
            plans.add(new SerialPlan(Lists.newArrayList((Object[])new Plan[]{new LeadTimePlan(leadTimeInsec), set.plan()})));
            leadTimeInsec += this.getLeadTime();
        }
        return this.parallel ? new ParallelPlan(plans) : new SerialPlan(plans);
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public int getLeadTime() {
        return this.leadTime;
    }

    public void setLeadTime(int leadTime) {
        this.leadTime = leadTime;
    }
}

