/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.resources;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xltest.domain.ElasticSearchStore;
import com.xebialabs.xltest.domain.EventProcessor;
import com.xebialabs.xltest.domain.LocalTestRun;
import com.xebialabs.xltest.domain.MySQLStore;
import com.xebialabs.xltest.domain.Store;
import com.xebialabs.xltest.domain.TestRunId;
import com.xebialabs.xltest.domain.TestSetDefinition;
import com.xebialabs.xltest.domain.definitions.FitNesse;
import com.xebialabs.xltest.service.EventRegistry;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/initlisteners")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class InitializeListenerController {
    private static final String RUN_ID_AS_USED_IN_JMETER = "a7f287f9-bb60-4596-b866-480811d09a49";
    private static final Logger LOG = LoggerFactory.getLogger(InitializeListenerController.class);
    private final RepositoryService repositoryService;
    private final EventRegistry eventRegistry;

    @Autowired
    public InitializeListenerController(RepositoryService repositoryService, EventRegistry eventRegistry) {
        this.repositoryService = repositoryService;
        this.eventRegistry = eventRegistry;
    }

    @GET
    @Path(value="/")
    public Response initializeRepoAndDispatcher() {
        Store store = this.createESStore();
        EventProcessor listener = this.createListener(store);
        TestSetDefinition testSetDefinition = this.createTestSetDefinition();
        this.createTestRun(testSetDefinition);
        this.eventRegistry.registerHandler(new TestRunId(RUN_ID_AS_USED_IN_JMETER), listener);
        return Response.ok().build();
    }

    private Store createESStore() {
        ElasticSearchStore store = new ElasticSearchStore("http://localhost:9200/xltestperformancetestevents");
        store.setId("Configuration/Stores/store");
        this.repositoryService.createOrUpdate((ConfigurationItem[])new Store[]{store});
        return store;
    }

    private Store createMySQLStore() {
        MySQLStore store = new MySQLStore("jdbc:mysql://localhost/test", "monty", "python", "testresults");
        store.setId("Configuration/Stores/store");
        this.repositoryService.createOrUpdate((ConfigurationItem[])new Store[]{store});
        return store;
    }

    private EventProcessor createListener(Store store) {
        ArrayList<Store> stores = new ArrayList<Store>();
        stores.add(store);
        EventProcessor listener = new EventProcessor("result", stores);
        listener.setId("Configuration/Listeners/listener");
        this.repositoryService.createOrUpdate((ConfigurationItem[])new EventProcessor[]{listener});
        return listener;
    }

    private TestSetDefinition createTestSetDefinition() {
        FitNesse testSetDefinition = new FitNesse();
        testSetDefinition.setSuiteName("ExampleSuite.ComplexSuite");
        testSetDefinition.setId("Configuration/TestSetDefinitions/demo");
        this.repositoryService.createOrUpdate((ConfigurationItem[])new FitNesse[]{testSetDefinition});
        return testSetDefinition;
    }

    private void createTestRun(TestSetDefinition testSetDefinition) {
        LocalTestRun testRun = new LocalTestRun();
        testRun.setTestSetDefinition(testSetDefinition);
        testRun.setId("Applications/TestRuns/a7f287f9-bb60-4596-b866-480811d09a49");
        this.repositoryService.createOrUpdate((ConfigurationItem[])new LocalTestRun[]{testRun});
    }

    @DELETE
    @Path(value="/")
    public Response removeListeners() {
        TestRunId testRunId = new TestRunId(RUN_ID_AS_USED_IN_JMETER);
        this.eventRegistry.unregisterAll(testRunId);
        return Response.ok().build();
    }
}

