/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.NoSuchEventPropertyException;
import com.xebialabs.xltest.domain.TestRunId;
import com.xebialabs.xltest.service.EventDispatcher;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialEventDispatcher
extends EventDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(SerialEventDispatcher.class);
    private Set<TestRunId> runningTasks = Collections.synchronizedSet(new HashSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeEventHandler(TestRunId testRunId, EventHandler handler, Event event) {
        this.runningTasks.add(testRunId);
        try {
            LOG.info("Invoking event for handler " + handler.getClass() + ": " + event);
            handler.onReceive(event);
        }
        catch (NoSuchEventPropertyException e) {
            LOG.info("Handler " + handler + " gave up: " + e.getMessage());
        }
        catch (Throwable e) {
            LOG.warn("Event handler threw event", e);
        }
        finally {
            this.runningTasks.remove(testRunId);
        }
    }
}

